/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.teams;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.stats.StatTracker;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Range;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public interface ITeam
extends IClientTracker {
    public long getID();

    public String getName();

    public StatTracker getStats();

    public PlayerReference getOwner();

    public List<PlayerReference> getAdmins();

    public List<PlayerReference> getMembers();

    default public List<PlayerReference> getAdminsAndOwner() {
        ArrayList<PlayerReference> result = new ArrayList<PlayerReference>(this.getAdmins());
        result.add(this.getOwner());
        return ImmutableList.copyOf(result);
    }

    default public List<PlayerReference> getAllMembers() {
        ArrayList<PlayerReference> result = new ArrayList<PlayerReference>();
        result.addAll(this.getMembers());
        result.addAll(this.getAdmins());
        result.add(this.getOwner());
        return ImmutableList.copyOf(result);
    }

    default public int getMemberCount() {
        return this.getMembers().size() + this.getAdmins().size() + 1;
    }

    public boolean hasBankAccount();

    public boolean canAccessBankAccount(PlayerReference var1);

    public boolean canAccessBankAccount(Player var1);

    public @Range(from=0L, to=2L) int getBankLimit();

    @Nullable
    public IBankAccount getBankAccount();

    @Nullable
    public BankReference getBankReference();

    default public boolean isAutoSalaryEnabled() {
        return this.getLastSalaryTime() > 0L;
    }

    public boolean getLoginRequiredForSalary();

    public long getLastSalaryTime();

    public boolean getSalaryNotification();

    public long getSalaryDelay();

    public boolean isSalaryCreative();

    public boolean isAdminSalarySeperate();

    public MoneyValue getMemberSalary();

    public MoneyValue getAdminSalary();

    public boolean failedLastSalaryAttempt();

    public List<MoneyValue> getTotalSalaryCost(boolean var1);

    public boolean canAffordNextSalary(boolean var1);

    public void forcePaySalaries(boolean var1);

    public boolean isOwner(Player var1);

    default public boolean isOwner(PlayerReference player) {
        return this.isOwner(player.id);
    }

    public boolean isOwner(UUID var1);

    public boolean isAdmin(Player var1);

    default public boolean isAdmin(PlayerReference player) {
        return this.isAdmin(player.id);
    }

    public boolean isAdmin(UUID var1);

    public boolean isMember(Player var1);

    default public boolean isMember(PlayerReference player) {
        return this.isMember(player.id);
    }

    public boolean isMember(UUID var1);
}

