/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.stats.types;

import io.github.lightman314.lightmanscurrency.api.money.value.MoneyStorage;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.api.stats.StatType;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class MultiMoneyStat
extends StatType<MoneyView, MoneyValue> {
    public static final ResourceLocation TYPE = VersionUtil.lcResource("multi_money");
    public static final StatType<MoneyView, MoneyValue> INSTANCE = new MultiMoneyStat();

    private MultiMoneyStat() {
    }

    @Override
    @Nonnull
    public ResourceLocation getID() {
        return TYPE;
    }

    @Override
    @Nonnull
    public StatType.Instance<MoneyView, MoneyValue> create() {
        return new MMInstance();
    }

    protected static class MMInstance
    extends StatType.Instance<MoneyView, MoneyValue> {
        private final MoneyStorage data = new MoneyStorage(() -> {});

        protected MMInstance() {
        }

        @Override
        @Nonnull
        protected StatType<MoneyView, MoneyValue> getType() {
            return INSTANCE;
        }

        @Override
        protected void saveAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider lookup) {
            tag.put("Value", (Tag)this.data.save());
        }

        @Override
        public void load(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider lookup) {
            this.data.load(tag.getList("Value", 10));
        }

        @Override
        public MoneyView get() {
            return this.data.getStoredMoney();
        }

        @Override
        protected void addInternal(@Nonnull MoneyValue addAmount) {
            this.data.addValue(addAmount);
        }

        @Override
        public void clear() {
            this.data.clear();
        }

        @Override
        public Object getDisplay() {
            return this.data.getRandomValueText();
        }
    }
}

