/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.value;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.types.CurrencyType;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;

public abstract class MoneyValueParser {
    public static final SimpleCommandExceptionType NO_VALUE_EXCEPTION = new SimpleCommandExceptionType((Message)LCText.ARGUMENT_MONEY_VALUE_NO_VALUE.get(new Object[0]));
    public final String prefix;

    protected MoneyValueParser(@Nonnull String prefix) {
        this.prefix = prefix;
    }

    protected boolean tryParse(@Nullable String prefix) {
        return this.prefix.equals(prefix);
    }

    protected abstract MoneyValue parseValueArgument(@Nonnull StringReader var1) throws CommandSyntaxException;

    @Nullable
    protected final String tryWrite(@Nonnull MoneyValue value) {
        String sub = this.writeValueArgument(value);
        if (sub != null) {
            return this.prefix + ";" + sub;
        }
        return null;
    }

    protected abstract String writeValueArgument(@Nonnull MoneyValue var1);

    @Nonnull
    public <S> CompletableFuture<Suggestions> listSuggestions(@Nonnull CommandContext<S> context, @Nonnull SuggestionsBuilder builder, @Nonnull String trail, @Nonnull HolderLookup<Item> items) {
        return Suggestions.empty();
    }

    protected void suggest(@Nonnull SuggestionsBuilder builder, @Nonnull String value) {
        builder.suggest(this.prefix + ";" + value);
    }

    public void addExamples(@Nonnull List<String> examples) {
    }

    @Nonnull
    public static MoneyValue ParseConfigString(String string, Supplier<MoneyValue> defaultValue) {
        try {
            return MoneyValueParser.parse(new StringReader(string), true);
        }
        catch (CommandSyntaxException exception) {
            LightmansCurrency.LogError("Error parsing Money Value config input.", new Object[]{exception});
            return defaultValue.get();
        }
    }

    @Nonnull
    public static MoneyValue parse(StringReader reader, boolean allowEmpty) throws CommandSyntaxException {
        StringReader inputReader = new StringReader(MoneyValueParser.readArgument(reader));
        String prefix = inputReader.getString().contains(";") ? MoneyValueParser.readStringUntil(inputReader, ';') : null;
        for (CurrencyType type : MoneyAPI.API.AllCurrencyTypes()) {
            StringReader readerCopy;
            MoneyValue value;
            MoneyValueParser parser = type.getValueParser();
            if (parser == null || !parser.tryParse(prefix) || (value = parser.parseValueArgument(readerCopy = new StringReader(inputReader))) == null) continue;
            if (allowEmpty) {
                return value;
            }
            if (value.isEmpty() || value.isFree()) {
                throw NO_VALUE_EXCEPTION.createWithContext((ImmutableStringReader)reader);
            }
            return value;
        }
        throw NO_VALUE_EXCEPTION.createWithContext((ImmutableStringReader)reader);
    }

    @Nonnull
    public static String writeParsable(@Nonnull MoneyValue value) {
        for (CurrencyType type : MoneyAPI.API.AllCurrencyTypes()) {
            String result;
            MoneyValueParser parser = type.getValueParser();
            if (parser == null || (result = parser.tryWrite(value)) == null) continue;
            return result;
        }
        return "ERROR";
    }

    private static String readArgument(@Nonnull StringReader reader) {
        int start = reader.getCursor();
        while (reader.canRead() && reader.peek() != ' ') {
            reader.skip();
        }
        return reader.getString().substring(start, reader.getCursor());
    }

    public static String readStringUntil(StringReader reader, char ... t) throws CommandSyntaxException {
        ArrayList<Character> terminators = new ArrayList<Character>();
        for (char c : t) {
            terminators.add(Character.valueOf(c));
        }
        StringBuilder result = new StringBuilder();
        boolean escaped = false;
        while (reader.canRead()) {
            char c = reader.read();
            if (escaped) {
                if (terminators.contains(Character.valueOf(c)) || c == '\\') {
                    result.append(c);
                    escaped = false;
                    continue;
                }
                reader.setCursor(reader.getCursor() - 1);
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidEscape().createWithContext((ImmutableStringReader)reader, (Object)String.valueOf(c));
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (terminators.contains(Character.valueOf(c))) {
                return result.toString();
            }
            result.append(c);
        }
        return result.toString();
    }
}

