/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.input;

import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.input.MoneyInputHandler;
import io.github.lightman314.lightmanscurrency.api.money.types.CurrencyType;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.Sprite;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.dropdown.DropdownWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidgetWithChildren;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class MoneyValueWidget
extends EasyWidgetWithChildren {
    public static final int HEIGHT = 69;
    public static final int WIDTH = 176;
    public static final ResourceLocation GUI_TEXTURE = VersionUtil.lcResource("textures/gui/coinvalueinput.png");
    public static final Sprite SPRITE_FREE_TOGGLE = Sprite.SimpleSprite(GUI_TEXTURE, 40, 69, 10, 10);
    public static final Sprite SPRITE_UP_ARROW = Sprite.SimpleSprite(GUI_TEXTURE, 0, 69, 20, 10);
    public static final Sprite SPRITE_DOWN_ARROW = Sprite.SimpleSprite(GUI_TEXTURE, 20, 69, 20, 10);
    public static final Sprite SPRITE_LEFT_ARROW = Sprite.SimpleSprite(GUI_TEXTURE, 50, 69, 10, 20);
    public static final Sprite SPRITE_RIGHT_ARROW = Sprite.SimpleSprite(GUI_TEXTURE, 60, 69, 10, 20);
    @Deprecated
    public static final Consumer<MoneyValue> EMPTY_CONSUMER = v -> {};
    private static String lastSelectedHandler = "lightmanscurrency:coins!main";
    private final boolean drawBG;
    public boolean allowFreeInput;
    private final Supplier<Boolean> allowHandlerChange;
    private boolean locked = false;
    private final Map<String, MoneyInputHandler> availableHandlers;
    private final List<String> handlerKeys = new ArrayList<String>();
    private MoneyInputHandler currentHandler = null;
    private MoneyValue currentValue;
    private final Consumer<MoneyValue> changeHandler;
    private final Consumer<MoneyValueWidget> handlerChangeConsumer;
    private final MoneyValueWidget oldWidget;

    public boolean canChangeHandlers() {
        return this.allowHandlerChange.get();
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void lock() {
        this.locked = true;
    }

    public void unlock() {
        this.locked = false;
    }

    @Nonnull
    public String getCurrentHandlerType() {
        return this.currentHandler == null ? "" : this.currentHandler.getUniqueName();
    }

    @Nullable
    public MoneyInputHandler getCurrentHandler() {
        return this.currentHandler;
    }

    public void tryMatchHandler(@Nonnull MoneyValue value) {
        if (this.getCurrentHandler().isForValue(value)) {
            return;
        }
        if (this.availableHandlers.containsKey(value.getUniqueName())) {
            this.setHandler(this.availableHandlers.get(value.getUniqueName()));
        } else {
            for (MoneyInputHandler handler : this.availableHandlers.values()) {
                if (!handler.isForValue(value)) continue;
                this.setHandler(handler);
                return;
            }
        }
    }

    @Nonnull
    public final MoneyValue getCurrentValue() {
        return this.currentValue;
    }

    private MoneyValueWidget(@Nonnull Builder builder) {
        super(builder);
        this.changeHandler = builder.handler;
        this.handlerChangeConsumer = builder.typeChangeHandler;
        this.currentValue = builder.oldWidget != null ? builder.oldWidget.currentValue : builder.startingValue;
        this.availableHandlers = this.setupHandlers();
        this.oldWidget = builder.oldWidget;
        this.drawBG = builder.drawBG;
        this.allowFreeInput = builder.allowFree;
        this.allowHandlerChange = builder.allowHandlerChange;
    }

    private Map<String, MoneyInputHandler> setupHandlers() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        HashMap<String, MoneyInputHandler> handlers = new HashMap<String, MoneyInputHandler>();
        for (CurrencyType type : MoneyAPI.API.AllCurrencyTypes()) {
            for (Object h : type.getInputHandlers((Player)player)) {
                if (!(h instanceof MoneyInputHandler)) continue;
                MoneyInputHandler handler = (MoneyInputHandler)h;
                handlers.put(handler.getUniqueName(), handler);
                handler.setup(this, x$0 -> this.addChild(x$0), x$0 -> this.removeChild(x$0), this::onHandlerChangeValue);
                this.handlerKeys.add(handler.getUniqueName());
            }
        }
        if (handlers.isEmpty()) {
            throw new RuntimeException("No valid MoneyInputHandlers are included in the registered CurrencyTypes!");
        }
        return handlers;
    }

    private MoneyInputHandler findDefaultHandler() {
        if (this.oldWidget != null && this.oldWidget.currentHandler != null && this.availableHandlers.containsKey(this.oldWidget.currentHandler.getUniqueName())) {
            return this.availableHandlers.get(this.oldWidget.currentHandler.getUniqueName());
        }
        MoneyValue value = this.currentValue;
        if (value.isEmpty() || value.isFree()) {
            if (this.availableHandlers.containsKey(lastSelectedHandler)) {
                return this.availableHandlers.get(lastSelectedHandler);
            }
        } else {
            String id = value.getUniqueName();
            if (this.availableHandlers.containsKey(id)) {
                return this.availableHandlers.get(id);
            }
            for (MoneyInputHandler handler : this.availableHandlers.values()) {
                if (!handler.isForValue(value)) continue;
                return handler;
            }
        }
        return this.availableHandlers.values().stream().toList().getFirst();
    }

    @Override
    public void addChildren(@Nonnull ScreenArea area) {
        this.setHandler(this.findDefaultHandler());
        this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(area.pos.offset(area.width - 14, 4))).pressAction(this::toggleFree)).sprite(SPRITE_FREE_TOGGLE).addon(EasyAddonHelper.visibleCheck(() -> this.visible && this.allowFreeInput))).build());
        this.addChild(((DropdownWidget.Builder)((DropdownWidget.Builder)DropdownWidget.builder().position(area.pos.offset(10, 4))).width(100).selected(this.handlerKeys.indexOf(this.currentHandler.getUniqueName())).selectAction(this::selectHandler).options(this.handlerNames()).addon(EasyAddonHelper.visibleCheck(() -> this.visible && this.availableHandlers.size() > 1 && this.allowHandlerChange.get() != false))).build());
    }

    private void checkHandler() {
        if (this.currentValue.isFree() || this.currentValue.isEmpty() || this.currentHandler != null && this.currentHandler.isForValue(this.currentValue)) {
            return;
        }
        if (this.availableHandlers.containsKey(this.currentValue.getUniqueName())) {
            this.setHandler(this.availableHandlers.get(this.currentValue.getUniqueName()));
        } else {
            for (MoneyInputHandler handler : this.availableHandlers.values()) {
                if (!handler.isForValue(this.currentValue)) continue;
                this.setHandler(handler);
                return;
            }
        }
    }

    private void setHandler(@Nonnull MoneyInputHandler handler) {
        if (this.currentHandler == handler) {
            return;
        }
        if (this.currentHandler != null) {
            this.removeChild(this.currentHandler);
            this.currentHandler.close();
        }
        this.currentHandler = handler;
        this.addChild(this.currentHandler);
        this.currentHandler.initialize(this.getArea());
        lastSelectedHandler = this.currentHandler.getUniqueName();
        this.markHandlerChanged();
    }

    public void markHandlerChanged() {
        this.handlerChangeConsumer.accept(this);
    }

    private List<Component> handlerNames() {
        ArrayList<Component> names = new ArrayList<Component>();
        for (String key : this.handlerKeys) {
            names.add(this.availableHandlers.get(key).inputName());
        }
        return names;
    }

    private void selectHandler(int handlerIndex) {
        if (handlerIndex < 0 || handlerIndex >= this.handlerKeys.size()) {
            return;
        }
        MoneyInputHandler handler = this.availableHandlers.get(this.handlerKeys.get(handlerIndex));
        if (handler != null) {
            this.setHandler(handler);
        }
    }

    @Override
    protected void renderTick() {
        if (this.currentHandler != null) {
            this.currentHandler.renderTick();
        }
    }

    @Override
    protected void renderWidget(@Nonnull EasyGuiGraphics gui) {
        if (this.drawBG) {
            gui.blit(GUI_TEXTURE, 0, 0, 0, 0, 176, 69);
        }
        if (this.currentHandler != null) {
            this.currentHandler.renderBG(gui);
        }
        int priceWidth = gui.font.width(this.currentValue.getString());
        int freeButtonOffset = this.allowFreeInput ? 15 : 5;
        gui.drawString((Component)this.currentValue.getText(), this.width - freeButtonOffset - priceWidth, 5, 0x404040);
    }

    private void toggleFree() {
        if (this.currentValue.isFree()) {
            this.changeValue(MoneyValue.empty());
        } else if (this.allowFreeInput) {
            this.changeValue(MoneyValue.free());
        }
    }

    private void onHandlerChangeValue(MoneyValue newValue) {
        if (newValue == null) {
            newValue = MoneyValue.empty();
        }
        if (newValue.isFree() && !this.allowFreeInput) {
            newValue = MoneyValue.empty();
        }
        this.currentValue = newValue;
        this.changeHandler.accept(newValue);
    }

    public void changeValue(@Nonnull MoneyValue newValue) {
        if (newValue.isFree() && !this.allowFreeInput) {
            newValue = MoneyValue.empty();
        }
        this.currentValue = newValue;
        this.checkHandler();
        this.changeHandler.accept(this.currentValue);
        if (this.currentHandler != null) {
            this.currentHandler.onValueChanged(newValue);
        }
    }

    @Override
    public boolean hideFromMouse() {
        return true;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @MethodsReturnNonnullByDefault
    @FieldsAreNonnullByDefault
    public static class Builder
    extends EasyWidget.EasyBuilder<Builder> {
        @Nullable
        private MoneyValueWidget oldWidget = null;
        private Consumer<MoneyValue> handler = v -> {};
        private Consumer<MoneyValueWidget> typeChangeHandler = w -> {};
        private MoneyValue startingValue = MoneyValue.empty();
        private boolean drawBG = false;
        private boolean allowFree = true;
        private Supplier<Boolean> allowHandlerChange = () -> true;

        private Builder() {
            super(176, 69);
        }

        @Override
        protected Builder getSelf() {
            return this;
        }

        public Builder old(@Nullable MoneyValueWidget widget) {
            this.oldWidget = widget;
            return this;
        }

        public Builder oldIfNotFirst(boolean firstOpen, @Nullable MoneyValueWidget widget) {
            if (firstOpen) {
                return this;
            }
            return this.old(widget);
        }

        public Builder valueHandler(Runnable handler) {
            this.handler = v -> handler.run();
            return this;
        }

        public Builder valueHandler(Consumer<MoneyValue> handler) {
            this.handler = handler;
            return this;
        }

        public Builder typeChangeListener(Consumer<MoneyValueWidget> handler) {
            this.typeChangeHandler = handler;
            return this;
        }

        public Builder typeChangeListener(Runnable handler) {
            this.typeChangeHandler = w -> handler.run();
            return this;
        }

        public Builder startingValue(MoneyValue value) {
            this.startingValue = value;
            return this;
        }

        public Builder startingValue(@Nullable TradeData trade) {
            if (trade == null) {
                return this;
            }
            return this.startingValue(trade.getCost());
        }

        public Builder drawBG() {
            return this.drawBG(true);
        }

        public Builder drawBG(boolean drawBG) {
            this.drawBG = drawBG;
            return this;
        }

        public Builder blockFreeInputs() {
            this.allowFree = false;
            return this;
        }

        public Builder allowHandlerChange(boolean allowHandlerChange) {
            this.allowHandlerChange = () -> allowHandlerChange;
            return this;
        }

        public Builder allowHandlerChange(Supplier<Boolean> allowHandlerChange) {
            this.allowHandlerChange = allowHandlerChange;
            return this;
        }

        public MoneyValueWidget build() {
            return new MoneyValueWidget(this);
        }
    }
}

