/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.coins.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.events.BuildDefaultMoneyDataEvent;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.atm.data.ATMData;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.CoinInputType;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.client.CoinInputTypeHelper;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.coin.CoinEntry;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.coin.MainCoinEntry;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.coin.SideBaseCoinEntry;
import io.github.lightman314.lightmanscurrency.api.money.coins.display.ValueDisplayAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.display.ValueDisplayData;
import io.github.lightman314.lightmanscurrency.api.money.coins.display.ValueDisplaySerializer;
import io.github.lightman314.lightmanscurrency.api.money.coins.display.builtin.Null;
import io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValue;
import io.github.lightman314.lightmanscurrency.common.attachments.EventUnlocks;
import io.github.lightman314.lightmanscurrency.common.items.TooltipItem;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.text.TextEntry;
import io.github.lightman314.lightmanscurrency.util.EnumUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ChainData {
    public static final Comparator<CoinEntry> SORT_HIGHEST_VALUE_FIRST = Comparator.comparingLong(CoinEntry::getCoreValue).reversed();
    public static final Comparator<CoinEntry> SORT_LOWEST_VALUE_FIRST = Comparator.comparingLong(CoinEntry::getCoreValue);
    public final boolean isEvent;
    public final String chain;
    private final Component displayName;
    private final CoinInputType inputType;
    private final ValueDisplayData displayData;
    private final ATMData atmData;
    private final List<CoinEntry> coreChain;
    private final List<List<CoinEntry>> sideChains;
    private final Map<ResourceLocation, CoinEntry> itemIdToEntryMap;
    private final List<CoinEntry> allEntryList;

    public Component getDisplayName() {
        return this.displayName;
    }

    public CoinInputType getInputType() {
        return this.inputType;
    }

    public ValueDisplayData getDisplayData() {
        return this.displayData;
    }

    public boolean isVisibleTo(@Nonnull Player player) {
        return !this.isEvent || EventUnlocks.isUnlocked(player, this.chain) || LCAdminMode.isAdminPlayer(player);
    }

    public boolean hasATMData() {
        return this.atmData != null && !this.atmData.getExchangeButtons().isEmpty();
    }

    @Nonnull
    public ATMData getAtmData() {
        return this.atmData;
    }

    @Nonnull
    public MutableComponent formatValue(@Nonnull CoinValue value, @Nonnull MutableComponent empty) {
        return this.displayData.formatValue(value, empty);
    }

    public void formatCoinTooltip(@Nonnull ItemStack stack, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        CoinEntry entry;
        this.displayData.formatCoinTooltip(stack, tooltip);
        if (flag.isAdvanced() && (entry = this.findEntry(stack)) != null) {
            tooltip.add((Component)LCText.TOOLTIP_COIN_ADVANCED_CHAIN.get(this.chain).withStyle(ChatFormatting.DARK_GRAY));
            tooltip.add((Component)LCText.TOOLTIP_COIN_ADVANCED_VALUE.get(DecimalFormat.getIntegerInstance().format(entry.getCoreValue())).withStyle(ChatFormatting.DARK_GRAY));
            if (entry.isSideChain()) {
                tooltip.add((Component)LCText.TOOLTIP_COIN_ADVANCED_SIDE_CHAIN.get(new Object[0]).withStyle(ChatFormatting.DARK_GRAY));
            } else {
                tooltip.add((Component)LCText.TOOLTIP_COIN_ADVANCED_CORE_CHAIN.get(new Object[0]).withStyle(ChatFormatting.DARK_GRAY));
            }
        }
    }

    protected ChainData(@Nonnull Builder builder) {
        this.chain = builder.chain;
        this.displayName = builder.displayName;
        this.displayData = builder.displayData;
        this.displayData.setParent(this);
        this.inputType = builder.inputType;
        this.coreChain = ImmutableList.copyOf(builder.coreChain.entries);
        this.isEvent = builder.isEvent;
        ArrayList temp = new ArrayList();
        builder.sideChains.forEach(chain -> temp.add(ImmutableList.copyOf(chain.entries)));
        this.sideChains = ImmutableList.copyOf(temp);
        this.atmData = builder.atmDataBuilder.build(this);
        this.defineEntryCoreValues();
        this.allEntryList = new ArrayList<CoinEntry>(this.coreChain);
        for (List<CoinEntry> sideChain : this.sideChains) {
            this.allEntryList.addAll(sideChain);
        }
        HashMap<ResourceLocation, CoinEntry> temp2 = new HashMap<ResourceLocation, CoinEntry>();
        for (CoinEntry entry : this.allEntryList) {
            temp2.put(BuiltInRegistries.ITEM.getKey((Object)entry.getCoin()), entry);
        }
        this.itemIdToEntryMap = ImmutableMap.copyOf(temp2);
        this.cacheCoinExchanges();
    }

    protected ChainData(@Nonnull List<CoinEntry> existingEntries, @Nonnull JsonObject json, @Nonnull HolderLookup.Provider lookup) throws JsonSyntaxException, ResourceLocationException {
        this.chain = GsonHelper.getAsString((JsonObject)json, (String)"chain");
        if (this.chain.equalsIgnoreCase("null")) {
            throw new JsonSyntaxException("Chain id cannot be null!");
        }
        this.displayName = (Component)((Pair)ComponentSerialization.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json.get("name")).getOrThrow(JsonSyntaxException::new)).getFirst();
        this.isEvent = GsonHelper.getAsBoolean((JsonObject)json, (String)"EventChain", (boolean)false);
        ResourceLocation displayType = VersionUtil.parseResource(GsonHelper.getAsString((JsonObject)json, (String)"displayType"));
        ValueDisplaySerializer displaySerializer = ValueDisplayAPI.get(displayType);
        if (displaySerializer == null) {
            throw new JsonSyntaxException(String.valueOf(displayType) + " is not a valid displayType");
        }
        displaySerializer.resetBuilder();
        displaySerializer.parseAdditional(json);
        this.inputType = (CoinInputType)EnumUtil.enumFromString((String)GsonHelper.getAsString((JsonObject)json, (String)"InputType"), (Enum[])CoinInputType.values(), null);
        if (this.inputType == null) {
            throw new JsonSyntaxException("InputType is not valid!");
        }
        JsonArray coreChainArray = GsonHelper.getAsJsonArray((JsonObject)json, (String)"CoreChain");
        if (coreChainArray.isEmpty()) {
            throw new JsonSyntaxException("CoreChain must have at least 1 entry!");
        }
        ArrayList<CoinEntry> coreChainTemp = new ArrayList<CoinEntry>();
        try {
            JsonObject baseEntry = coreChainArray.get(0).getAsJsonObject();
            CoinEntry temp = CoinEntry.parse(baseEntry);
            ChainData.validateNoDuplicateCoins(temp, existingEntries);
            coreChainTemp.add(temp);
            displaySerializer.parseAdditionalFromCoin(temp, baseEntry);
        }
        catch (JsonSyntaxException | ResourceLocationException e) {
            throw new JsonSyntaxException("Error parsing core chain entry #1 in the " + this.chain + " chain!", e);
        }
        for (int i = 1; i < coreChainArray.size(); ++i) {
            try {
                JsonObject entry = coreChainArray.get(i).getAsJsonObject();
                CoinEntry temp = MainCoinEntry.parseMain(entry);
                ChainData.validateNoDuplicateCoins(temp, existingEntries);
                displaySerializer.parseAdditionalFromCoin(temp, entry);
                coreChainTemp.add(temp);
                continue;
            }
            catch (JsonSyntaxException | ResourceLocationException e) {
                throw new JsonSyntaxException("Error parsing core chain entry #" + (i + 1) + " in the " + this.chain + " chain!", e);
            }
        }
        this.coreChain = ImmutableList.copyOf(coreChainTemp);
        ArrayList<ImmutableList> sideChainsTemp = new ArrayList<ImmutableList>();
        JsonArray sideChainsArray = GsonHelper.getAsJsonArray((JsonObject)json, (String)"SideChains", (JsonArray)new JsonArray());
        for (int c = 0; c < sideChainsArray.size(); ++c) {
            try {
                JsonArray chainArray = sideChainsArray.get(c).getAsJsonArray();
                if (chainArray.isEmpty()) continue;
                ArrayList<CoinEntry> tempList = new ArrayList<CoinEntry>();
                try {
                    JsonObject baseEntry = chainArray.get(0).getAsJsonObject();
                    CoinEntry temp = SideBaseCoinEntry.parseSub(baseEntry, this.coreChain);
                    ChainData.validateNoDuplicateCoins(temp, existingEntries);
                    displaySerializer.parseAdditionalFromCoin(temp, baseEntry);
                    tempList.add(temp);
                }
                catch (JsonSyntaxException | ResourceLocationException e) {
                    throw new JsonSyntaxException("Error parsing entry #1 in side chain #" + (c + 1) + " in the " + this.chain + " chain!", e);
                }
                for (int i = 1; i < chainArray.size(); ++i) {
                    try {
                        JsonObject entry = chainArray.get(i).getAsJsonObject();
                        CoinEntry temp = MainCoinEntry.parseMain(entry, true);
                        ChainData.validateNoDuplicateCoins(temp, existingEntries);
                        displaySerializer.parseAdditionalFromCoin(temp, entry);
                        tempList.add(temp);
                        continue;
                    }
                    catch (JsonSyntaxException | ResourceLocationException e) {
                        throw new JsonSyntaxException("Error parsing entry #" + (i + 1) + " in side chain #" + (c + 1) + " in the " + this.chain + " chain!", e);
                    }
                }
                sideChainsTemp.add(ImmutableList.copyOf(tempList));
                continue;
            }
            catch (JsonSyntaxException | ResourceLocationException e) {
                throw new JsonSyntaxException("Error parsing side chain #" + (c + 1) + " in the " + this.chain + " chain!", e);
            }
        }
        this.sideChains = ImmutableList.copyOf(sideChainsTemp);
        this.displayData = displaySerializer.build();
        this.displayData.setParent(this);
        this.atmData = json.has("ATMData") ? ATMData.parse(GsonHelper.getAsJsonObject((JsonObject)json, (String)"ATMData"), this, lookup) : ATMData.builder(null).build(this);
        this.defineEntryCoreValues();
        this.allEntryList = new ArrayList<CoinEntry>(this.coreChain);
        for (List<CoinEntry> sideChain : this.sideChains) {
            this.allEntryList.addAll(sideChain);
        }
        HashMap<ResourceLocation, CoinEntry> temp2 = new HashMap<ResourceLocation, CoinEntry>();
        for (CoinEntry entry : this.allEntryList) {
            temp2.put(BuiltInRegistries.ITEM.getKey((Object)entry.getCoin()), entry);
        }
        this.itemIdToEntryMap = ImmutableMap.copyOf(temp2);
        this.cacheCoinExchanges();
    }

    private void defineEntryCoreValues() {
        long coreValue = 1L;
        for (int i = 0; i < this.coreChain.size(); ++i) {
            CoinEntry entry = this.coreChain.get(i);
            if (i == 0) {
                entry.setCoreValue(coreValue);
                continue;
            }
            entry.setCoreValue(coreValue *= (long)entry.getExchangeRate());
        }
        for (List<CoinEntry> sideChain : this.sideChains) {
            coreValue = 0L;
            for (int i = 0; i < sideChain.size(); ++i) {
                CoinEntry entry = sideChain.get(i);
                if (i == 0 && entry instanceof SideBaseCoinEntry) {
                    SideBaseCoinEntry e = (SideBaseCoinEntry)entry;
                    coreValue = e.parentCoin.getCoreValue();
                }
                entry.setCoreValue(coreValue *= (long)entry.getExchangeRate());
            }
        }
    }

    public JsonObject getAsJson(@Nonnull HolderLookup.Provider lookup) {
        JsonObject json = new JsonObject();
        json.addProperty("chain", this.chain);
        json.add("name", (JsonElement)ComponentSerialization.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.displayName).getOrThrow(JsonSyntaxException::new));
        json.addProperty("displayType", this.displayData.getType().toString());
        this.displayData.getSerializer().writeAdditional(this.displayData, json);
        json.addProperty("InputType", this.inputType.name());
        if (this.isEvent) {
            json.addProperty("EventChain", Boolean.valueOf(true));
        }
        JsonArray coreChainArray = new JsonArray();
        for (CoinEntry entry : this.coreChain) {
            coreChainArray.add((JsonElement)entry.serialize(this.displayData));
        }
        json.add("CoreChain", (JsonElement)coreChainArray);
        if (!this.sideChains.isEmpty()) {
            JsonArray sideChainArray = new JsonArray();
            for (List<CoinEntry> sideChain : this.sideChains) {
                JsonArray chainArray = new JsonArray();
                for (CoinEntry entry : sideChain) {
                    chainArray.add((JsonElement)entry.serialize(this.displayData));
                }
                sideChainArray.add((JsonElement)chainArray);
            }
            json.add("SideChains", (JsonElement)sideChainArray);
        }
        if (!this.atmData.getExchangeButtons().isEmpty()) {
            json.add("ATMData", (JsonElement)this.atmData.save(lookup));
        }
        return json;
    }

    public boolean containsEntry(@Nonnull ItemStack item) {
        return this.findEntry(item) != null;
    }

    public boolean containsEntry(@Nonnull Item item) {
        return this.findEntry(item) != null;
    }

    @Nullable
    public CoinEntry findMatchingEntry(@Nonnull CoinEntry entry) {
        for (CoinEntry e : this.getAllEntries(true)) {
            if (!e.matches(entry)) continue;
            return e;
        }
        return null;
    }

    @Nullable
    public CoinEntry findEntry(@Nonnull ItemStack item) {
        return this.findEntry(item.getItem());
    }

    @Nullable
    public CoinEntry findEntry(@Nonnull Item item) {
        return this.itemIdToEntryMap.get(BuiltInRegistries.ITEM.getKey((Object)item));
    }

    @Nonnull
    public List<CoinEntry> getAllEntries(boolean includeSideChains, @Nonnull Comparator<CoinEntry> sorter) {
        List<CoinEntry> list = this.getAllEntries(includeSideChains);
        list.sort(sorter);
        return list;
    }

    @Nonnull
    public List<CoinEntry> getAllEntries(boolean includeSideChains) {
        if (includeSideChains) {
            return new ArrayList<CoinEntry>(this.allEntryList);
        }
        return new ArrayList<CoinEntry>(this.coreChain);
    }

    @Nonnull
    public List<CoinEntry> getCoreChain() {
        return this.coreChain;
    }

    @Nonnull
    public List<List<CoinEntry>> getSideChains() {
        return this.sideChains;
    }

    public long getCoreValue(@Nonnull ItemStack item) {
        return this.getCoreValue(item.getItem());
    }

    public long getCoreValue(@Nonnull Item item) {
        CoinEntry entry = this.findEntry(item);
        if (entry == null) {
            return 0L;
        }
        return entry.getCoreValue();
    }

    private void cacheCoinExchanges() {
        for (int i = 0; i < this.coreChain.size(); ++i) {
            CoinEntry entry = this.coreChain.get(i);
            Pair down = null;
            if (i > 0) {
                down = Pair.of((Object)this.coreChain.get(i - 1), (Object)entry.getExchangeRate());
            }
            Pair up = null;
            if (i < this.coreChain.size() - 1) {
                CoinEntry nextEntry = this.coreChain.get(i + 1);
                up = Pair.of((Object)nextEntry, (Object)nextEntry.getExchangeRate());
            }
            entry.defineExchanges((Pair<CoinEntry, Integer>)down, up);
        }
        for (List<CoinEntry> sideChain : this.sideChains) {
            for (int i = 0; i < sideChain.size(); ++i) {
                CoinEntry entry = sideChain.get(i);
                Pair down = null;
                if (i == 0) {
                    if (entry instanceof SideBaseCoinEntry) {
                        SideBaseCoinEntry e = (SideBaseCoinEntry)entry;
                        down = Pair.of((Object)e.parentCoin, (Object)e.getExchangeRate());
                    }
                } else {
                    down = Pair.of((Object)sideChain.get(i - 1), (Object)entry.getExchangeRate());
                }
                Pair up = null;
                if (i < sideChain.size() - 1) {
                    CoinEntry nextEntry = sideChain.get(i + 1);
                    up = Pair.of((Object)nextEntry, (Object)nextEntry.getExchangeRate());
                }
                entry.defineExchanges((Pair<CoinEntry, Integer>)down, up);
            }
        }
    }

    @Nullable
    public Pair<CoinEntry, Integer> getLowerExchange(@Nonnull Item item) {
        CoinEntry entry = this.findEntry(item);
        if (entry == null) {
            return null;
        }
        return entry.getLowerExchange();
    }

    @Nullable
    @Deprecated(since="2.2.0.4")
    public Pair<CoinEntry, Integer> getLowerExchange(@Nonnull CoinEntry entry) {
        return entry.getLowerExchange();
    }

    @Nullable
    public Pair<CoinEntry, Integer> getUpperExchange(@Nonnull Item item) {
        CoinEntry entry = this.findEntry(item);
        if (entry == null) {
            return null;
        }
        return entry.getUpperExchange();
    }

    @Nullable
    @Deprecated(since="2.2.0.4")
    public Pair<CoinEntry, Integer> getUpperExchange(@Nonnull CoinEntry entry) {
        return entry.getUpperExchange();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object getInputHandler() {
        return CoinInputTypeHelper.getHandler(this.inputType, this);
    }

    private static void validateNoDuplicateCoins(@Nonnull CoinEntry newEntry, @Nonnull List<CoinEntry> existingEntries) {
        for (CoinEntry entry : existingEntries) {
            if (!entry.matches(newEntry.getCoin()) && !newEntry.matches(entry)) continue;
            throw new JsonSyntaxException("Matching coin entry for " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)newEntry.getCoin())) + " is already present");
        }
        existingEntries.add(newEntry);
    }

    public static Builder builder(@Nonnull String chain) {
        return new Builder(BuildDefaultMoneyDataEvent.getExistingEntries(), chain, Component.translatable((String)("lightmanscurrency.money.chain." + chain)));
    }

    public static Builder builder(@Nonnull String chain, @Nonnull MutableComponent displayName) {
        return new Builder(BuildDefaultMoneyDataEvent.getExistingEntries(), chain, displayName);
    }

    public static Builder builder(@Nonnull String chain, @Nonnull TextEntry displayName) {
        return new Builder(BuildDefaultMoneyDataEvent.getExistingEntries(), chain, displayName.get(new Object[0]));
    }

    public static ChainData fromJson(@Nonnull List<CoinEntry> existingEntries, @Nonnull JsonObject json, @Nonnull HolderLookup.Provider lookup) throws JsonSyntaxException, ResourceLocationException {
        return new ChainData(existingEntries, Objects.requireNonNull(json), lookup);
    }

    public static void addCoinTooltips(@Nonnull ItemStack stack, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag, @Nullable Player player) {
        ChainData chain = CoinAPI.API.ChainDataOfCoin(stack);
        if (chain != null) {
            ArrayList<Component> lines = new ArrayList<Component>();
            if (player == null || flag.isAdvanced() || flag.isCreative() || chain.isVisibleTo(player)) {
                chain.formatCoinTooltip(stack, lines, flag);
            }
            TooltipItem.insertTooltip(tooltip, lines);
        }
    }

    public static class Builder {
        private static Builder latest = null;
        public final String chain;
        private final MutableComponent displayName;
        private boolean isEvent = false;
        private ValueDisplayData displayData = Null.INSTANCE;
        private CoinInputType inputType = CoinInputType.DEFAULT;
        private ChainBuilder coreChain = null;
        private final List<ChainBuilder> sideChains = new ArrayList<ChainBuilder>();
        private final List<CoinEntry> existingEntries;
        private final ATMData.Builder atmDataBuilder = ATMData.builder(this);

        public static Builder getLatest() {
            return latest;
        }

        private void validateNoDuplicateEntries(@Nonnull CoinEntry newEntry) {
            ChainData.validateNoDuplicateCoins(newEntry, this.existingEntries);
        }

        private Builder(@Nonnull List<CoinEntry> existingEntries, @Nonnull String chain, @Nonnull MutableComponent displayName) {
            this.chain = chain;
            this.displayName = displayName;
            this.existingEntries = existingEntries;
            latest = this;
        }

        public Builder withDisplay(@Nonnull ValueDisplayData display) {
            this.displayData = display;
            return this;
        }

        public Builder withInputType(@Nonnull CoinInputType inputType) {
            this.inputType = inputType;
            return this;
        }

        public Builder asEvent() {
            this.isEvent = true;
            return this;
        }

        public ChainBuilder withCoreChain(@Nonnull Supplier<? extends ItemLike> baseCoin) {
            return this.withCoreChain(baseCoin.get());
        }

        public ChainBuilder withCoreChain(@Nonnull ItemLike baseCoin) {
            if (this.coreChain != null) {
                throw new IllegalArgumentException("Core Chain has already been built!");
            }
            this.coreChain = new ChainBuilder(this, new CoinEntry(baseCoin.asItem()));
            return this.coreChain;
        }

        public ChainBuilder getCoreChain() {
            if (this.coreChain == null) {
                throw new IllegalArgumentException("Core Chain has not yet been built!");
            }
            return this.coreChain;
        }

        public ChainBuilder withSideChain(@Nonnull Supplier<? extends ItemLike> baseCoin, int exchangeRate, @Nonnull Supplier<? extends ItemLike> parentCoin) {
            return this.withSideChain(baseCoin.get(), exchangeRate, parentCoin.get());
        }

        public ChainBuilder withSideChain(@Nonnull ItemLike baseCoin, int exchangeRate, @Nonnull ItemLike parentCoin) {
            if (this.coreChain == null) {
                throw new IllegalArgumentException("Cannot build a side chain until the core chain has been built!");
            }
            CoinEntry parentEntry = null;
            for (CoinEntry entry : this.coreChain.entries) {
                if (!entry.matches(parentCoin.asItem())) continue;
                parentEntry = entry;
                break;
            }
            if (parentEntry == null) {
                throw new IllegalArgumentException("Coin is not in the core chain!");
            }
            ChainBuilder subChain = new ChainBuilder(this, new SideBaseCoinEntry(baseCoin.asItem(), parentEntry, exchangeRate));
            this.sideChains.add(subChain);
            return subChain;
        }

        public List<ChainBuilder> getSideChains() {
            return ImmutableList.copyOf(this.sideChains);
        }

        public ATMData.Builder atmBuilder() {
            return this.atmDataBuilder;
        }

        public void apply(@Nonnull BuildDefaultMoneyDataEvent event) {
            event.addDefault(this);
        }

        public void apply(@Nonnull BuildDefaultMoneyDataEvent event, boolean allowOverride) {
            event.addDefault(this, allowOverride);
        }

        @Nonnull
        public ChainData build() {
            return new ChainData(this);
        }

        public static final class ChainBuilder {
            private final Builder parent;
            private final List<CoinEntry> entries = new ArrayList<CoinEntry>();

            private ChainBuilder(@Nonnull Builder parent, @Nonnull CoinEntry baseCoin) {
                this.parent = parent;
                this.parent.validateNoDuplicateEntries(baseCoin);
                this.entries.add(baseCoin);
            }

            public ChainBuilder withCoin(@Nonnull Supplier<? extends ItemLike> coin, int exchangeRate) {
                return this.withCoin(coin.get(), exchangeRate);
            }

            public ChainBuilder withCoin(@Nonnull ItemLike coin, int exchangeRate) {
                MainCoinEntry newEntry = new MainCoinEntry(coin.asItem(), exchangeRate);
                this.parent.validateNoDuplicateEntries(newEntry);
                this.entries.add(newEntry);
                return this;
            }

            public Builder back() {
                return this.parent;
            }

            public List<CoinEntry> getEntries() {
                return ImmutableList.copyOf(this.entries);
            }
        }
    }
}

