/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.settings.directional;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.IDirectionalSettingsObject;
import io.github.lightman314.lightmanscurrency.util.EnumUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.MutableComponent;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public enum DirectionalSettingsState {
    NONE,
    INPUT,
    INPUT_AND_OUTPUT,
    OUTPUT;


    public boolean allowsInputs() {
        return this == INPUT || this == INPUT_AND_OUTPUT;
    }

    public boolean allowsOutputs() {
        return this == OUTPUT || this == INPUT_AND_OUTPUT;
    }

    public DirectionalSettingsState getNext(IDirectionalSettingsObject object) {
        switch (this.ordinal()) {
            case 0: {
                if (object.allowInputs()) {
                    return INPUT;
                }
                if (object.allowOutputs()) {
                    return OUTPUT;
                }
                return NONE;
            }
            case 1: {
                if (object.allowOutputs()) {
                    return INPUT_AND_OUTPUT;
                }
                return NONE;
            }
            case 2: {
                return OUTPUT;
            }
            case 3: {
                return NONE;
            }
        }
        return NONE;
    }

    public DirectionalSettingsState getPrevious(IDirectionalSettingsObject object) {
        switch (this.ordinal()) {
            case 3: {
                if (object.allowInputs()) {
                    return INPUT_AND_OUTPUT;
                }
                return NONE;
            }
            case 2: {
                return INPUT;
            }
            case 1: {
                return NONE;
            }
            case 0: {
                if (object.allowOutputs()) {
                    return OUTPUT;
                }
                if (object.allowInputs()) {
                    return INPUT;
                }
                return NONE;
            }
        }
        return NONE;
    }

    public MutableComponent getText() {
        return LCText.GUI_DIRECTIONAL_STATE.get(this).get(new Object[0]);
    }

    public static DirectionalSettingsState parse(String value) {
        return (DirectionalSettingsState)EnumUtil.enumFromString((String)value, (Enum[])DirectionalSettingsState.values(), (Enum)NONE);
    }
}

