/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.events;

import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationData;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;

public class NotificationEvent
extends Event {
    private final UUID playerID;
    private final NotificationData data;
    protected Notification notification;

    public UUID getPlayerID() {
        return this.playerID;
    }

    public NotificationData getData() {
        return this.data;
    }

    public Notification getNotification() {
        return this.notification;
    }

    public NotificationEvent(UUID playerID, NotificationData data, Notification notification) {
        this.playerID = playerID;
        this.data = data;
        this.notification = notification;
    }

    public static class NotificationReceivedOnClient
    extends NotificationEvent
    implements ICancellableEvent {
        public NotificationReceivedOnClient(UUID playerID, NotificationData data, Notification notification) {
            super(playerID, data, notification);
        }
    }

    public static class NotificationSent
    extends NotificationEvent {
        protected NotificationSent(UUID playerID, NotificationData data, Notification notification) {
            super(playerID, data, notification);
        }

        public static class Post
        extends NotificationSent {
            public Post(UUID playerID, NotificationData data, Notification notification) {
                super(playerID, data, notification);
            }
        }

        public static class Pre
        extends NotificationSent
        implements ICancellableEvent {
            public Pre(UUID playerID, NotificationData data, Notification notification) {
                super(playerID, data, notification);
            }

            public void setNotification(@Nonnull Notification notification) {
                if (notification == null) {
                    throw new NullPointerException("Cannot set the notification to null. Cancel the event if you wish for no notification to be sent.");
                }
                this.notification = notification;
            }
        }
    }
}

