/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.enchantments;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.capability.money.CapabilityMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.common.attachments.WalletHandler;
import io.github.lightman314.lightmanscurrency.common.enchantments.CoinMagnetEnchantment;
import io.github.lightman314.lightmanscurrency.common.enchantments.MoneyMendingEnchantment;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.LivingEntity;

public class EnchantmentUtil {
    private EnchantmentUtil() {
    }

    public static void tickAllEnchantments(@Nonnull LivingEntity entity, @Nullable IMoneyHandler entityMoney) {
        EnchantmentUtil.tickCoinMagnet(entity);
        if (entityMoney == null && (entityMoney = (IMoneyHandler)entity.getCapability(CapabilityMoneyHandler.MONEY_HANDLER_ENTITY)) == null) {
            LightmansCurrency.LogDebug("Cannot run Money Mending tick without a money handler!");
        }
        if (entityMoney != null) {
            EnchantmentUtil.tickMoneyMending(entity, entityMoney);
        }
    }

    public static void tickCoinMagnet(@Nonnull LivingEntity entity) {
        ProfilerFiller filler = entity.level().getProfiler();
        filler.push("Coin Magnet Tick");
        WalletHandler walletHandler = WalletHandler.get(entity);
        if (walletHandler != null) {
            CoinMagnetEnchantment.runEntityTick(walletHandler, entity);
        }
        filler.pop();
    }

    public static void tickMoneyMending(@Nonnull LivingEntity entity, @Nonnull IMoneyHandler entityMoney) {
        ProfilerFiller filler = entity.level().getProfiler();
        filler.push("Money Mending Tick");
        MoneyMendingEnchantment.runEntityTick(entity, entityMoney);
        filler.pop();
    }
}

