/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.easy_data.editable;

import io.github.lightman314.lightmanscurrency.api.easy_data.EasyData;
import io.github.lightman314.lightmanscurrency.api.easy_data.EasyDataSettings;
import io.github.lightman314.lightmanscurrency.api.easy_data.util.DualEditableNotificationReplacer;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class DualEditableData<T, A, B>
extends EasyData<T> {
    private static final ResourceLocation REPLACER_TYPE = VersionUtil.lcResource("dual_editable_notification_replacer");
    private final DualEditableNotificationReplacer<T, A, B> editNotificationReplacer;

    public DualEditableData(EasyDataSettings<T> builder) {
        super(builder);
        DualEditableNotificationReplacer r;
        Object object = builder.getCustomField(REPLACER_TYPE);
        this.editNotificationReplacer = object instanceof DualEditableNotificationReplacer ? (r = (DualEditableNotificationReplacer)object) : null;
    }

    public static <T, A, B, X extends DualEditableData<T, A, B>> EasyDataSettings.Builder<T, X> builder(Function<EasyDataSettings<T>, X> builder, DualEditableNotificationReplacer<T, A, B> editableNotificationReplacer) {
        return EasyDataSettings.builder(builder).custom(REPLACER_TYPE, editableNotificationReplacer);
    }

    public final void tryEdit(Player player, A value1, B value2) {
        if (this.settings.category.canEdit(player, this.settings.host)) {
            Consumer<Notification> consumer;
            PlayerReference pr = PlayerReference.of(player);
            Notification notification = this.edit(pr, value1, value2);
            if (this.editNotificationReplacer != null) {
                notification = this.editNotificationReplacer.replaceNotification(this.get(), value1, value2, pr, this.settings, notification);
            }
            if (notification != null && (consumer = this.settings.host.dataChangeNotifier()) != null) {
                consumer.accept(notification);
            }
        }
    }

    @Nullable
    protected abstract Notification edit(PlayerReference var1, A var2, B var3);
}

