/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.options.basic;

import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParser;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BooleanOption
extends ConfigOption<Boolean> {
    public static final ConfigParser<Boolean> PARSER = new Parser();

    protected BooleanOption(@Nonnull Supplier<Boolean> defaultValue) {
        super(defaultValue);
    }

    @Override
    @Nonnull
    protected ConfigParser<Boolean> getParser() {
        return PARSER;
    }

    public static BooleanOption createTrue() {
        return BooleanOption.create(() -> true);
    }

    public static BooleanOption createFalse() {
        return BooleanOption.create(() -> false);
    }

    public static BooleanOption create(@Nonnull Supplier<Boolean> defaultValue) {
        return new BooleanOption(defaultValue);
    }

    @Override
    @Nullable
    protected String bonusComment() {
        return "Default: " + String.valueOf(this.getDefaultValue());
    }

    private static class Parser
    implements ConfigParser<Boolean> {
        private Parser() {
        }

        @Override
        @Nonnull
        public Boolean tryParse(@Nonnull String cleanLine) {
            return Boolean.parseBoolean(cleanLine);
        }

        @Override
        @Nonnull
        public String write(@Nonnull Boolean value) {
            return Boolean.toString(value);
        }
    }
}

