/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.event;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.neoforged.bus.api.Event;

public abstract class ConfigReloadAllEvent
extends Event
implements IClientTracker {
    private final boolean logicalClient;
    private List<ConfigFile> reloadingFiles = null;

    @Override
    public boolean isClient() {
        return this.logicalClient;
    }

    @Nonnull
    public List<ConfigFile> reloadedFiles() {
        if (this.reloadingFiles == null) {
            ArrayList<ConfigFile> results = new ArrayList<ConfigFile>();
            for (ConfigFile file : ConfigFile.getAvailableFiles()) {
                if (!file.shouldReload(this.logicalClient)) continue;
                results.add(file);
            }
            this.reloadingFiles = ImmutableList.copyOf(results);
        }
        return this.reloadingFiles;
    }

    public ConfigReloadAllEvent(boolean logicalClient) {
        this.logicalClient = logicalClient;
    }

    public static class Post
    extends ConfigReloadAllEvent {
        public Post(boolean logicalClient) {
            super(logicalClient);
        }
    }

    public static class Pre
    extends ConfigReloadAllEvent {
        public Pre(boolean logicalClient) {
            super(logicalClient);
        }
    }
}

