/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.itemindicator.render;

import io.github.cotrin8672.itemindicator.ItemIndicator;
import io.github.cotrin8672.itemindicator.render.ItemOverlay;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0012\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lio/github/cotrin8672/itemindicator/render/EnchantmentIconOverlayRenderer;", "Lio/github/cotrin8672/itemindicator/render/ItemOverlay;", "<init>", "()V", "Lnet/minecraft/client/gui/GuiGraphics;", "guiGraphics", "Lnet/minecraft/client/gui/Font;", "textRenderer", "Lnet/minecraft/world/item/ItemStack;", "stack", "", "xOffset", "yOffset", "", "render", "(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;II)Z", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "FORTUNE_ICON", "Lnet/minecraft/resources/ResourceLocation;", "SILK_TOUCH_ICON", "itemindicator"})
public final class EnchantmentIconOverlayRenderer
implements ItemOverlay {
    @NotNull
    public static final EnchantmentIconOverlayRenderer INSTANCE = new EnchantmentIconOverlayRenderer();
    private static final ResourceLocation FORTUNE_ICON = ResourceLocation.fromNamespaceAndPath((String)"itemindicator", (String)"textures/gui/fortune_icon.png");
    private static final ResourceLocation SILK_TOUCH_ICON = ResourceLocation.fromNamespaceAndPath((String)"itemindicator", (String)"textures/gui/silk_touch_icon.png");

    private EnchantmentIconOverlayRenderer() {
    }

    @Override
    public boolean render(@NotNull GuiGraphics guiGraphics, @NotNull Font textRenderer, @NotNull ItemStack stack, int xOffset, int yOffset) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Intrinsics.checkNotNullParameter((Object)textRenderer, (String)"textRenderer");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!ItemIndicator.INSTANCE.getCONFIG().getRenderEnchantmentOverlay()) {
            return false;
        }
        Object object = Minecraft.getInstance().level;
        if (object == null || (object = object.registryAccess()) == null || (object = object.asGetterLookup()) == null || (object = object.get(Enchantments.FORTUNE.registryKey(), Enchantments.FORTUNE)) == null) {
            return false;
        }
        Object fortune = object;
        Object object2 = Minecraft.getInstance().level;
        if (object2 == null || (object2 = object2.registryAccess()) == null || (object2 = object2.asGetterLookup()) == null || (object2 = object2.get(Enchantments.SILK_TOUCH.registryKey(), Enchantments.SILK_TOUCH)) == null) {
            return false;
        }
        Object silkTouch = object2;
        if (stack.getEnchantments().getLevel((Holder)((Optional)silkTouch).get()) != 0) {
            guiGraphics.blit(SILK_TOUCH_ICON, xOffset + 1, yOffset + 1, 0.0f, 0.0f, 4, 4, 4, 4);
        } else if (stack.getEnchantments().getLevel((Holder)((Optional)fortune).get()) != 0) {
            guiGraphics.blit(FORTUNE_ICON, xOffset + 1, yOffset + 1, 0.0f, 0.0f, 4, 4, 4, 4);
        }
        return true;
    }
}

