/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod;

import dev.mineland.item_interactions_mod.CarriedInteractions.Spawners.GuiParticleSpawner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record SpawnerRegistry() {
    public static Map<Item, List<ResourceLocation>> MAPPED_ITEMS_LIST = new HashMap<Item, List<ResourceLocation>>();
    public static Map<ResourceLocation, GuiParticleSpawner> SPAWNER_MAP = new HashMap<ResourceLocation, GuiParticleSpawner>();

    public static void clear() {
        MAPPED_ITEMS_LIST.clear();
        SPAWNER_MAP.clear();
    }

    public static List<GuiParticleSpawner> get(ItemStack item) {
        List<ResourceLocation> spawnerIds = MAPPED_ITEMS_LIST.get(item.getItem());
        ArrayList<GuiParticleSpawner> result = new ArrayList<GuiParticleSpawner>();
        if (spawnerIds == null) {
            return result;
        }
        for (ResourceLocation id : spawnerIds) {
            GuiParticleSpawner guiParticleSpawner = SpawnerRegistry.getSpawnerFromId(id);
            if (guiParticleSpawner == null || !guiParticleSpawner.matches(item)) continue;
            result.add(guiParticleSpawner);
        }
        return result;
    }

    public static List<ResourceLocation> getList(ItemStack item) {
        List<ResourceLocation> spawnerIds = MAPPED_ITEMS_LIST.get(item.getItem());
        ArrayList<ResourceLocation> result = new ArrayList<ResourceLocation>();
        if (spawnerIds == null) {
            return result;
        }
        for (ResourceLocation id : spawnerIds) {
            GuiParticleSpawner guiParticleSpawner = SpawnerRegistry.getSpawnerFromId(id);
            if (guiParticleSpawner == null || !guiParticleSpawner.matches(item)) continue;
            result.add(id);
        }
        return result;
    }

    public static GuiParticleSpawner getSpawnerFromId(ResourceLocation id) {
        return SPAWNER_MAP.getOrDefault(id, null);
    }

    public static void register(GuiParticleSpawner guiParticleSpawner, ResourceLocation id) {
        List<ItemStack> items = guiParticleSpawner.getAppliedItems();
        SPAWNER_MAP.put(id, guiParticleSpawner);
        for (ItemStack item : items) {
            if (!MAPPED_ITEMS_LIST.containsKey(item.getItem())) {
                MAPPED_ITEMS_LIST.put(item.getItem(), new ArrayList());
            }
            if (MAPPED_ITEMS_LIST.get(item.getItem()).contains(id)) continue;
            MAPPED_ITEMS_LIST.get(item.getItem()).add(id);
        }
    }

    public static boolean compareSpawner(List<GuiParticleSpawner> carriedGuiParticleSpawner, ItemStack carriedItem) {
        ArrayList<ResourceLocation> carriedList = new ArrayList<ResourceLocation>();
        List<ResourceLocation> itemList = SpawnerRegistry.getList(carriedItem);
        for (GuiParticleSpawner s : carriedGuiParticleSpawner) {
            carriedList.add(s.getName());
        }
        return new HashSet(carriedList).containsAll(itemList);
    }

    public static List<GuiParticleSpawner> create(List<GuiParticleSpawner> itemGuiParticleSpawnerList) {
        ArrayList<GuiParticleSpawner> result = new ArrayList<GuiParticleSpawner>();
        for (GuiParticleSpawner a : itemGuiParticleSpawnerList) {
            result.add(a.duplicate());
        }
        return result;
    }
}

