/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.mineland.item_interactions_mod.GlobalDirt;
import dev.mineland.item_interactions_mod.ItemInteractionsConfig;
import dev.mineland.item_interactions_mod.itemcarriedalgs.AnimScale;
import dev.mineland.item_interactions_mod.itemcarriedalgs.AnimSpeed;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;

public class GuiRendererHelper {
    private static final HashMap<ResourceLocation, int[]> particleSizesCache = new HashMap();

    public static void clearCache() {
        particleSizesCache.clear();
    }

    public static void blit(PoseStack pose, ResourceLocation resourceLocation, int i, int j, float f, float g, int k, int l, int m, int n, int color) {
        GuiRendererHelper.blit(pose, resourceLocation, i, j, k, l, f, g, k, l, m, n, color);
    }

    static void blit(PoseStack pose, ResourceLocation resourceLocation, int i, int j, int k, int l, float f, float g, int m, int n, int o, int p, int color) {
        GuiRendererHelper.blit(pose, resourceLocation, i, i + k, j, j + l, 0, m, n, f, g, o, p, color);
    }

    static void blit(PoseStack pose, ResourceLocation resourceLocation, int i, int j, int k, int l, int m, int n, int o, float f, float g, int p, int q, int color) {
        GuiRendererHelper.blit(pose, resourceLocation, i, j, k, l, m, (f + 0.0f) / (float)p, (f + (float)n) / (float)p, (g + 0.0f) / (float)q, (g + (float)o) / (float)q, color);
    }

    static void blit(PoseStack pose, ResourceLocation resourceLocation, int i, int j, int k, int l, int m, float f, float g, float h, float n, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GuiRendererHelper.innerBlitTinted(pose, resourceLocation, i, j, k, l, m, f, g, h, n, red, green, blue, alpha);
    }

    static void innerBlitTinted(PoseStack pose, ResourceLocation resourceLocation, int i, int j, int k, int l, int m, float f, float g, float h, float n, float o, float p, float q, float r) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resourceLocation);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = pose.last().pose();
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferBuilder.addVertex(matrix4f, (float)i, (float)k, (float)m).setUv(f, h).setColor(o, p, q, r);
        bufferBuilder.addVertex(matrix4f, (float)i, (float)l, (float)m).setUv(f, n).setColor(o, p, q, r);
        bufferBuilder.addVertex(matrix4f, (float)j, (float)l, (float)m).setUv(g, n).setColor(o, p, q, r);
        bufferBuilder.addVertex(matrix4f, (float)j, (float)k, (float)m).setUv(g, h).setColor(o, p, q, r);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void renderItem(GuiGraphics guiGraphics, ItemStack itemStack, Level level, LivingEntity livingEntity, int k, Minecraft minecraft, int initialX, int initialY, int initialZ) {
        PoseStack newPose = new PoseStack();
        int x = initialX;
        int y = initialY;
        switch (ItemInteractionsConfig.getAnimationSetting()) {
            case ANIM_SCALE: {
                newPose = AnimScale.makePose(x + 16, y + 16, 0);
                break;
            }
            case ANIM_SPEED: {
                newPose = AnimSpeed.makePose(x + 8, y + 8, 150, GlobalDirt.speedX, GlobalDirt.speedY, GlobalDirt.isCurrentItem3d);
            }
        }
        newPose.pushPose();
        guiGraphics.pose().mulPose(newPose.last().pose());
    }

    public static int[] getSize(ResourceLocation particleLocation) {
        if (particleSizesCache.containsKey(particleLocation)) {
            return particleSizesCache.get(particleLocation);
        }
        return particleSizesCache.getOrDefault(particleLocation, new int[]{0, 0});
    }

    public static boolean setParticleSizeCache(ResourceLocation particleLocation) {
        try {
            InputStream stream = Minecraft.getInstance().getResourceManager().open(particleLocation);
            NativeImage image = NativeImage.read((InputStream)stream);
            int[] sizes = new int[]{image.getWidth(), image.getHeight()};
            particleSizesCache.put(particleLocation, sizes);
            return true;
        }
        catch (IOException e) {
            particleSizesCache.put(particleLocation, new int[]{0, 0});
            return false;
        }
    }
}

