/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod.CarriedInteractions.Particles;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.mineland.item_interactions_mod.CarriedInteractions.Particles.BaseParticle;
import dev.mineland.item_interactions_mod.GlobalDirt;
import dev.mineland.item_interactions_mod.GuiRendererHelper;
import dev.mineland.item_interactions_mod.Item_interactions_mod;
import dev.mineland.item_interactions_mod.MiscUtils;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public class TexturedParticle
extends BaseParticle {
    int tintStart;
    int tintEnd;
    TextureType textureType;
    JsonObject textureMcMeta;
    ResourceLocation particleLocation;
    List<ResourceLocation> frames;
    int width;
    int height;
    double frametime;
    int textureIndex;
    boolean interpolate;
    int length;
    double totalLifeTime;
    boolean isMCMetaAnimatedTexture;

    public TexturedParticle(GuiGraphics guiGraphics, double x, double y, double speedX, double speedY, double accelerationX, double accelerationY, double frictionX, double frictionY, double lifeTime, ResourceLocation particleLocation, int tintStart, int tintEnd) {
        this(guiGraphics, x, y, speedX, speedY, accelerationX, accelerationY, frictionX, frictionY, lifeTime, particleLocation, TextureType.LIFETIME, tintStart, tintEnd);
    }

    public TexturedParticle(GuiGraphics guiGraphics, double x, double y, double speedX, double speedY, double accelerationX, double accelerationY, double frictionX, double frictionY, double lifeTime, ResourceLocation particleLocation, TextureType textureType, int tintStart, int tintEnd) {
        super(guiGraphics, x, y, speedX, speedY, accelerationX, accelerationY, frictionX, frictionY, tintStart, tintEnd, lifeTime);
        this.particleLocation = particleLocation;
        this.textureType = textureType;
        this.totalLifeTime = lifeTime;
        this.frames = this.getTexturesFromArray(particleLocation);
    }

    private List<ResourceLocation> getTexturesFromArray(ResourceLocation particleLocation) {
        try {
            Resource a = (Resource)Minecraft.getInstance().getResourceManager().getResource(particleLocation.withPrefix("particles/").withSuffix(".json")).orElseThrow();
            ArrayList<ResourceLocation> finalList = new ArrayList<ResourceLocation>();
            JsonElement json = JsonParser.parseReader((Reader)a.openAsReader());
            for (JsonElement textureJson : json.getAsJsonObject().get("textures").getAsJsonArray()) {
                ResourceLocation raw = ResourceLocation.parse((String)textureJson.getAsString());
                Object path = raw.getPath().startsWith("textures/") ? raw.getPath() : "textures/particle/" + raw.getPath();
                path = ((String)path).endsWith(".png") ? path : (String)path + ".png";
                finalList.add(ResourceLocation.fromNamespaceAndPath((String)raw.getNamespace(), (String)path));
            }
            this.length = finalList.size();
            this.isMCMetaAnimatedTexture = false;
            return finalList;
        }
        catch (Exception e) {
            ArrayList<ResourceLocation> r = new ArrayList<ResourceLocation>();
            r.add(ResourceLocation.parse((String)"minecraft:textures/missingno.png"));
            return r;
        }
    }

    @Override
    public void render() {
        int totalTextureWidth;
        int totalTextureHeight;
        block7: {
            super.render();
            this.particleLocation = this.frames.get(this.textureIndex);
            totalTextureHeight = 16;
            totalTextureWidth = 16;
            try {
                int[] size = GuiRendererHelper.getSize(this.particleLocation);
                totalTextureHeight = size[0];
                totalTextureWidth = size[1];
            }
            catch (Exception e) {
                if (!GlobalDirt.devenv) break block7;
                Item_interactions_mod.errorMessage("Died loading particle!" + String.valueOf(e));
            }
        }
        boolean yStart = false;
        int uvHeight = totalTextureHeight;
        switch (this.textureType.ordinal()) {
            case 0: {
                break;
            }
            case 2: {
                if (this.length == 0) break;
                int index = (int)Math.floor(this.lifeTime / this.maxTick * (double)this.length);
                this.textureIndex = Math.clamp((long)index, 0, this.length - 1);
                break;
            }
            case 1: {
                if (this.lifeTime % this.frametime != 0.0) break;
                this.textureIndex = (this.textureIndex + 1) % (this.length + 1);
            }
        }
        int finalColor = MiscUtils.colorLerp((float)Math.clamp(this.lifeTime / this.maxTick, 0.0, 1.0), this.colorStart, this.colorEnd);
        this.guiGraphics.pose().pushPose();
        this.guiGraphics.pose().translate(0.0f, 0.0f, 399.0f);
        GuiRendererHelper.blit(this.guiGraphics.pose(), this.frames.get(this.textureIndex), (int)this.x - totalTextureWidth / 2, (int)this.y - uvHeight / 2, 0.0f, (float)yStart, totalTextureWidth, uvHeight, totalTextureWidth, totalTextureHeight, finalColor);
        this.guiGraphics.pose().popPose();
    }

    @Override
    public void tick() {
        super.tick();
        this.x += this.speedX / 20.0;
        this.y += this.speedY / 20.0;
        this.speedX = (this.speedX + this.accelerationX) * this.frictionX;
        this.speedY = (this.speedY + this.accelerationY) * this.frictionY;
        if (this.x + (double)this.width < 0.0 || this.x - (double)this.width > (double)Minecraft.getInstance().getWindow().getGuiScaledWidth() || this.y + (double)this.height < 0.0 || this.y - (double)this.height > (double)Minecraft.getInstance().getWindow().getGuiScaledHeight()) {
            this.shouldDelete = true;
        }
    }

    public static enum TextureType {
        STATIC(0),
        FRAMETIME(1),
        LIFETIME(2);

        final int typeId;

        private TextureType(int i) {
            this.typeId = i;
        }
    }
}

