/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.utils.cradles;

import com.mojang.serialization.Codec;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.utils.EntityCradle;
import com.samsthenerd.inline.utils.FakeClientPlayerMaker;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;

public class PlayerCradle
extends EntityCradle {
    private final ResolvableProfile profile;

    public PlayerCradle(ResolvableProfile profile) {
        this.profile = profile;
    }

    public ResolvableProfile getProfile() {
        return this.profile;
    }

    @Override
    public EntityCradle.CradleType<?> getType() {
        return PlayerCradleType.INSTANCE;
    }

    @Override
    public String getId() {
        return this.profile.id().map(Object::toString).orElseGet(() -> (String)this.profile.name().get());
    }

    @Override
    public Entity getEntity(Level world) {
        return FakeClientPlayerMaker.getPlayerEntity(this.profile);
    }

    private static class PlayerCradleType
    implements EntityCradle.CradleType<PlayerCradle> {
        public static PlayerCradleType INSTANCE = EntityCradle.addCradleType(new PlayerCradleType());

        private PlayerCradleType() {
        }

        @Override
        public ResourceLocation getId() {
            return Inline.id("nbt");
        }

        @Override
        public Codec<PlayerCradle> getCodec() {
            return ResolvableProfile.CODEC.xmap(PlayerCradle::new, PlayerCradle::getProfile);
        }
    }
}

