/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.utils;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.datafixers.util.Either;
import com.samsthenerd.inline.mixin.core.NativeImageAccessor;
import com.samsthenerd.inline.utils.IntPair;
import com.samsthenerd.inline.utils.SpriteUVLens;
import com.samsthenerd.inline.utils.SpriteUVRegion;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.PointerBuffer;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

@FunctionalInterface
public interface ImgFormatParser {
    public static final Map<String, ImgFormatParser> PARSERS = new HashMap<String, ImgFormatParser>();

    public Either<ImgParseResult, String> tryParse(InputStream var1, String var2);

    public static void loadBuiltinParsers() {
        PARSERS.put("image/png", ImgFormatParser::parsePNG);
        PARSERS.put("image/gif", ImgFormatParser::parseGIF);
        PARSERS.put("image/jpeg", ImgFormatParser::parseImgSTBI);
    }

    public static ImgFormatParser getFormatParser(String contentType) {
        if (contentType == null) {
            return ImgFormatParser::parseImgSTBI;
        }
        return PARSERS.getOrDefault(contentType, ImgFormatParser::parseImgSTBI);
    }

    public static Either<ImgParseResult, String> parsePNG(InputStream inStream, String contentType) {
        try {
            NativeImage img = NativeImage.read((InputStream)inStream);
            IntPair dims = new IntPair(img.getWidth(), img.getHeight());
            return Either.left((Object)new ImgParseResult(dims, SpriteUVRegion.FULL.asLens(), img));
        }
        catch (IOException e) {
            return Either.right((Object)e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Either<ImgParseResult, String> parseGIF(InputStream inStream, String contentType) {
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            ByteBuffer buf = TextureUtil.readResource((InputStream)inStream).rewind();
            PointerBuffer delayBuf = memoryStack.mallocPointer(1);
            IntBuffer wBuf = memoryStack.mallocInt(1);
            IntBuffer hBuf = memoryStack.mallocInt(1);
            IntBuffer framesBuf = memoryStack.mallocInt(1);
            IntBuffer channelsBuf = memoryStack.mallocInt(1);
            ByteBuffer imageBuf = STBImage.stbi_load_gif_from_memory((ByteBuffer)buf, (PointerBuffer)delayBuf, (IntBuffer)wBuf, (IntBuffer)hBuf, (IntBuffer)framesBuf, (IntBuffer)channelsBuf, (int)4);
            if (imageBuf == null) {
                Either either2 = Either.right((Object)("Could not load image as gif: " + STBImage.stbi_failure_reason()));
                return either2;
            }
            NativeImage image = new NativeImage(wBuf.get(0), hBuf.get(0) * framesBuf.get(0), true);
            MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)imageBuf), (long)((NativeImageAccessor)image).getPixels(), (long)((long)wBuf.get(0) * (long)hBuf.get(0) * (long)framesBuf.get(0) * 4L));
            int[] delays = new int[framesBuf.get(0)];
            delayBuf.getIntBuffer(framesBuf.get(0)).get(delays);
            ImgParseResult imgRes = new ImgParseResult(new IntPair(wBuf.get(0), hBuf.get(0) * framesBuf.get(0)), (SpriteUVLens)new SpriteUVLens.AnimUVLens(1.0 / (double)framesBuf.get(0), true, delays), image);
            Either either = Either.left((Object)imgRes);
            return either;
        }
        catch (Exception e) {
            return Either.right((Object)e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Either<ImgParseResult, String> parseImgSTBI(InputStream inStream, String contentType) {
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            ByteBuffer buf = TextureUtil.readResource((InputStream)inStream).rewind();
            IntBuffer wBuf = memoryStack.mallocInt(1);
            IntBuffer hBuf = memoryStack.mallocInt(1);
            IntBuffer channelsBuf = memoryStack.mallocInt(1);
            ByteBuffer imageBuf = STBImage.stbi_load_from_memory((ByteBuffer)buf, (IntBuffer)wBuf, (IntBuffer)hBuf, (IntBuffer)channelsBuf, (int)4);
            if (imageBuf == null) {
                Either either2 = Either.right((Object)("Could not load image here: " + STBImage.stbi_failure_reason()));
                return either2;
            }
            NativeImage image = new NativeImage(wBuf.get(0), hBuf.get(0), true);
            MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)imageBuf), (long)((NativeImageAccessor)image).getPixels(), (long)((long)wBuf.get(0) * (long)hBuf.get(0) * 4L));
            ImgParseResult imgRes = new ImgParseResult(new IntPair(wBuf.get(0), hBuf.get(0)), SpriteUVRegion.FULL.asLens(), image);
            Either either = Either.left((Object)imgRes);
            return either;
        }
        catch (Exception e) {
            return Either.right((Object)e.toString());
        }
    }

    public record ImgParseResult(IntPair dims, SpriteUVLens lens, Function<ResourceLocation, ResourceLocation> registerTextureCallback) {
        ImgParseResult(IntPair dims, SpriteUVLens lens, NativeImage img) {
            this(dims, lens, (ResourceLocation origId) -> {
                DynamicTexture texture = new DynamicTexture(img);
                Minecraft.getInstance().getTextureManager().register(origId, (AbstractTexture)texture);
                return origId;
            });
        }
    }
}

