/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.tooltips.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.samsthenerd.inline.tooltips.data.SpriteTooltipData;
import com.samsthenerd.inline.utils.SpriteUVRegion;
import com.samsthenerd.inline.utils.Spritelike;
import com.samsthenerd.inline.utils.SpritelikeRenderers;
import java.util.function.BiFunction;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;

public class SpriteTooltipComponent
implements ClientTooltipComponent {
    public static final float DEFAULT_RENDER_SIZE = 96.0f;
    private Spritelike sprite;
    private BiFunction<Integer, Integer, Integer> widthProvider;

    public SpriteTooltipComponent(SpriteTooltipData tt) {
        this.sprite = tt.sprite;
        this.widthProvider = tt.widthProvider;
    }

    public void renderImage(Font font, int mouseX, int mouseY, GuiGraphics context) {
        ResourceLocation textureId = this.sprite.getTextureId();
        if (textureId == null || textureId.equals((Object)ResourceLocation.parse((String)""))) {
            return;
        }
        PoseStack ps = context.pose();
        ps.pushPose();
        ps.translate((float)mouseX, (float)mouseY, 500.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        SpritelikeRenderers.getRenderer(this.sprite).drawSprite(this.sprite, context, 0.0f, 0.0f, 0.0f, this.getWidth(font), this.getRenderHeight());
        ps.popPose();
    }

    public int getWidth(Font pFont) {
        SpriteUVRegion uvs = this.sprite.getUVs();
        return this.widthProvider.apply((int)(uvs.uWidth() * (double)this.sprite.getTextureWidth()), (int)(uvs.vHeight() * (double)this.sprite.getTextureHeight()));
    }

    private int getRenderHeight() {
        SpriteUVRegion uvs = this.sprite.getUVs();
        int realWidth = this.widthProvider.apply((int)(uvs.uWidth() * (double)this.sprite.getTextureWidth()), (int)(uvs.vHeight() * (double)this.sprite.getTextureHeight()));
        if (realWidth == 0 || this.sprite.getTextureWidth() == 0) {
            return 0;
        }
        return (int)((double)realWidth * (double)this.sprite.getTextureHeight() / (double)this.sprite.getTextureWidth());
    }

    public int getHeight() {
        return this.getRenderHeight() + 4;
    }
}

