/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.api.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.client.GlowHandling;
import com.samsthenerd.inline.api.client.InlineRenderer;
import com.samsthenerd.inline.api.client.renderers.InlineSpriteRenderer;
import com.samsthenerd.inline.api.data.PlayerHeadData;
import com.samsthenerd.inline.api.data.SpriteInlineData;
import com.samsthenerd.inline.utils.TextureSprite;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class PlayerHeadRenderer
implements InlineRenderer<PlayerHeadData> {
    public static final PlayerHeadRenderer INSTANCE = new PlayerHeadRenderer();

    @Override
    public ResourceLocation getId() {
        return Inline.id("playerhead");
    }

    public ResourceLocation textureFromHeadData(PlayerHeadData data) {
        SkinManager playerSkinProvider = Minecraft.getInstance().getSkinManager();
        return playerSkinProvider.getInsecureSkin(data.profile().gameProfile()).texture();
    }

    public SpriteInlineData getFace(PlayerHeadData data) {
        TextureSprite faceSprite = TextureSprite.fromPixels(this.textureFromHeadData(data), 8, 8, 8, 8, 64, 64);
        return new SpriteInlineData(faceSprite);
    }

    public SpriteInlineData getOuter(PlayerHeadData data) {
        TextureSprite faceSprite = TextureSprite.fromPixels(this.textureFromHeadData(data), 40, 8, 8, 8, 64, 64);
        return new SpriteInlineData(faceSprite);
    }

    @Override
    public int render(PlayerHeadData data, GuiGraphics context, int index, Style style, int codepoint, InlineRenderer.TextRenderingContext trContext) {
        SpriteInlineData faceSpriteData = this.getFace(data);
        PoseStack matrices = context.pose();
        matrices.pushPose();
        matrices.translate(0.25, 0.25, 0.0);
        matrices.scale(0.9411765f, 0.9411765f, 1.0f);
        InlineSpriteRenderer.INSTANCE.render(faceSpriteData, context, index, style, codepoint, trContext);
        matrices.popPose();
        SpriteInlineData outerSpriteData = this.getOuter(data);
        matrices.pushPose();
        matrices.translate(0.0f, 0.0f, 10.0f);
        int res = InlineSpriteRenderer.INSTANCE.render(outerSpriteData, context, index, style, codepoint, trContext);
        matrices.popPose();
        return res;
    }

    @Override
    public int charWidth(PlayerHeadData data, Style style, int codepoint) {
        return 8;
    }

    @Override
    public GlowHandling getGlowPreference(PlayerHeadData forData) {
        return new GlowHandling.Full(forData.profile().id().map(Objects::toString).orElseGet(() -> (String)forData.profile().name().get()).toLowerCase());
    }
}

