/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.api.client.renderers;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.client.GlowHandling;
import com.samsthenerd.inline.api.client.InlineRenderer;
import com.samsthenerd.inline.api.data.ItemInlineData;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;

public class InlineItemRenderer
implements InlineRenderer<ItemInlineData> {
    public static final InlineItemRenderer INSTANCE = new InlineItemRenderer();
    public static boolean debugEarlyReturn = true;

    @Override
    public ResourceLocation getId() {
        return Inline.id("item");
    }

    @Override
    public int render(ItemInlineData data, GuiGraphics context, int index, Style style, int codepoint, InlineRenderer.TextRenderingContext trContext) {
        boolean flat;
        if (trContext.shadow()) {
            return 8;
        }
        PoseStack matrices = context.pose();
        ItemStack stack = data.getStack();
        Minecraft client = Minecraft.getInstance();
        ClientLevel world = client.level;
        if (stack.isEmpty()) {
            return 8;
        }
        BakedModel bakedModel = client.getItemRenderer().getModel(stack, (Level)world, null, 0);
        boolean bl = flat = !bakedModel.usesBlockLight();
        if (flat && InlineRenderer.isFlat(matrices, trContext.layerType())) {
            Lighting.setupForFlatItems();
        }
        matrices.pushPose();
        matrices.translate(4.0f, 4.0f, 0.0f);
        try {
            matrices.mulPose(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
            matrices.scale(8.0f, 8.0f, 8.0f);
            client.getItemRenderer().render(stack, ItemDisplayContext.GUI, false, matrices, (MultiBufferSource)context.bufferSource(), trContext.light(), OverlayTexture.NO_OVERLAY, bakedModel);
            context.bufferSource().endBatch();
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)throwable, (String)"Rendering item");
            CrashReportCategory crashReportSection = crashReport.addCategory("Item being rendered");
            crashReportSection.setDetail("Item Type", () -> String.valueOf(stack.getItem()));
            crashReportSection.setDetail("Item Components", () -> String.valueOf(stack.getComponents()));
            crashReportSection.setDetail("Item Foil", () -> String.valueOf(stack.hasFoil()));
            throw new ReportedException(crashReport);
        }
        matrices.popPose();
        return 8;
    }

    @Override
    public int charWidth(ItemInlineData data, Style style, int codepoint) {
        return 8;
    }

    @Override
    public GlowHandling getGlowPreference(ItemInlineData forData) {
        BakedModel bakedModel = Minecraft.getInstance().getItemRenderer().getModel(forData.getStack(), (Level)Minecraft.getInstance().level, null, 0);
        return new GlowHandling.Full(forData.getStack().getDescriptionId() + Integer.toHexString(bakedModel.hashCode()));
    }
}

