/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.haydenapi.configuration.format;

import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import dev.denismasterherobrine.haydenapi.configuration.annotation.Entry;
import dev.denismasterherobrine.haydenapi.configuration.exception.ConfigurationException;
import dev.denismasterherobrine.haydenapi.configuration.format.FormatHandler;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;

public class YamlConfigurationHandler
implements FormatHandler {
    private final YAMLMapper yamlMapper = new YAMLMapper();

    @Override
    public <T> T load(File file, Class<T> configClass) throws ConfigurationException {
        try {
            byte[] bytes = Files.readAllBytes(file.toPath());
            Map map = (Map)this.yamlMapper.readValue(bytes, HashMap.class);
            for (Field field : configClass.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(Entry.class)) continue;
                field.setAccessible(true);
                if (!map.containsKey(field.getName())) continue;
                Object value = map.get(field.getName());
                Object converted = this.yamlMapper.convertValue(value, field.getType());
                field.set(null, converted);
            }
            return configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ConfigurationException("Error loading YAML file: " + file.getName(), e);
        }
    }

    @Override
    public <T> void save(File file, T config) throws ConfigurationException {
        try {
            Class<?> configClass = config.getClass();
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Field field : configClass.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(Entry.class)) continue;
                field.setAccessible(true);
                Object value = field.get(null);
                map.put(field.getName(), value);
            }
            byte[] bytes = this.yamlMapper.writerWithDefaultPrettyPrinter().writeValueAsBytes(map);
            Files.write(file.toPath(), bytes, new OpenOption[0]);
        }
        catch (Exception e) {
            throw new ConfigurationException("Error saving YAML file: " + file.getName(), e);
        }
    }
}

