/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.haydenapi.configuration.api;

import dev.denismasterherobrine.haydenapi.configuration.ConfigurationManager;
import dev.denismasterherobrine.haydenapi.configuration.exception.ConfigurationException;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ConfigurationAPI {
    private static final Logger LOGGER = Logger.getLogger(ConfigurationAPI.class.getName());
    private static final ConfigurationManager manager = new ConfigurationManager();

    private ConfigurationAPI() {
    }

    public static <T> T createConfig(String path, Class<T> configClass) throws ConfigurationException {
        try {
            return manager.initializeConfig(path, configClass);
        }
        catch (ConfigurationException e) {
            LOGGER.log(Level.SEVERE, "Error initializing configuration: " + e.getMessage(), e);
            throw e;
        }
    }

    public static <T> void saveConfig(String filename, T config) throws ConfigurationException {
        File file = new File(filename);
        try {
            manager.saveConfig(file, config);
        }
        catch (ConfigurationException e) {
            LOGGER.log(Level.SEVERE, "Error saving configuration: " + e.getMessage(), e);
            throw e;
        }
    }

    public static <T> T reloadConfig(String filename, Class<T> configClass) throws ConfigurationException {
        File file = new File(filename);
        try {
            T config = manager.loadConfig(file, configClass);
            return config;
        }
        catch (ConfigurationException e) {
            LOGGER.log(Level.SEVERE, "Error reloading configuration: " + e.getMessage(), e);
            throw e;
        }
    }
}

