/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.store;

import guideme.internal.shaded.lucene.store.BufferedChecksum;
import guideme.internal.shaded.lucene.store.ChecksumIndexInput;
import guideme.internal.shaded.lucene.store.IndexInput;
import java.io.IOException;
import java.util.zip.CRC32;

public class BufferedChecksumIndexInput
extends ChecksumIndexInput {
    final IndexInput main;
    final BufferedChecksum digest;

    public BufferedChecksumIndexInput(IndexInput main) {
        super("BufferedChecksumIndexInput(" + String.valueOf(main) + ")");
        this.main = main;
        this.digest = new BufferedChecksum(new CRC32());
    }

    @Override
    public byte readByte() throws IOException {
        byte b = this.main.readByte();
        this.digest.update(b);
        return b;
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.main.readBytes(b, offset, len);
        this.digest.update(b, offset, len);
    }

    @Override
    public short readShort() throws IOException {
        short v = this.main.readShort();
        this.digest.updateShort(v);
        return v;
    }

    @Override
    public int readInt() throws IOException {
        int v = this.main.readInt();
        this.digest.updateInt(v);
        return v;
    }

    @Override
    public long readLong() throws IOException {
        long v = this.main.readLong();
        this.digest.updateLong(v);
        return v;
    }

    @Override
    public void readLongs(long[] dst, int offset, int length) throws IOException {
        this.main.readLongs(dst, offset, length);
        this.digest.updateLongs(dst, offset, length);
    }

    @Override
    public long getChecksum() {
        return this.digest.getValue();
    }

    @Override
    public void close() throws IOException {
        this.main.close();
    }

    @Override
    public long getFilePointer() {
        return this.main.getFilePointer();
    }

    @Override
    public long length() {
        return this.main.length();
    }

    @Override
    public IndexInput clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        throw new UnsupportedOperationException();
    }
}

