/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;

public record ShareWaypointPacket(String name, GlobalPos position, ShareType shareType, List<UUID> targets) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ShareWaypointPacket> TYPE = new CustomPacketPayload.Type(FTBChunksAPI.rl("share_waypoint_packet"));
    public static final StreamCodec<FriendlyByteBuf, ShareWaypointPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, ShareWaypointPacket::name, (StreamCodec)GlobalPos.STREAM_CODEC, ShareWaypointPacket::position, ShareType.STREAM_CODEC, ShareWaypointPacket::shareType, (StreamCodec)UUIDUtil.STREAM_CODEC.apply(ByteBufCodecs.list()), ShareWaypointPacket::targets, ShareWaypointPacket::new);

    public CustomPacketPayload.Type<ShareWaypointPacket> type() {
        return TYPE;
    }

    public static void handle(ShareWaypointPacket message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            ServerPlayer serverPlayer = (ServerPlayer)context.getPlayer();
            PlayerList playerList = serverPlayer.getServer().getPlayerList();
            List<ServerPlayer> playersToSend = switch (message.shareType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> playerList.getPlayers();
                case 1 -> {
                    Optional teamForPlayer = FTBTeamsAPI.api().getManager().getTeamForPlayer(serverPlayer);
                    if (teamForPlayer.isPresent()) {
                        Team team = (Team)teamForPlayer.get();
                        yield team.getMembers().stream().map(arg_0 -> ((PlayerList)playerList).getPlayer(arg_0)).filter(Objects::nonNull).toList();
                    }
                    yield List.of(serverPlayer);
                }
                case 2 -> message.targets.stream().map(arg_0 -> ((PlayerList)playerList).getPlayer(arg_0)).filter(Objects::nonNull).toList();
            };
            ChatType.Bound chatBound = ChatType.bind((ResourceKey)ChatType.CHAT, (Entity)serverPlayer).withTargetName(serverPlayer.getDisplayName());
            for (ServerPlayer playerListPlayer : playersToSend) {
                String cords = message.position.pos().getX() + " " + message.position.pos().getY() + " " + message.position.pos().getZ();
                String dim = message.position.dimension().location().toString();
                MutableComponent waypointText = Component.literal((String)message.name).withStyle(style -> style.withColor(ChatFormatting.AQUA).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)(dim + " " + cords)))));
                playerListPlayer.sendChatMessage(OutgoingChatMessage.create((PlayerChatMessage)PlayerChatMessage.system((String)"").withUnsignedContent((Component)Component.translatable((String)"ftbchunks.waypoint.shared", (Object[])new Object[]{waypointText}).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ftbchunks waypoint add \"" + message.name + "\" " + cords + " " + dim + " white true"))))), false, chatBound);
            }
        });
    }

    public static enum ShareType {
        SERVER,
        PARTY,
        PLAYER;

        public static final StreamCodec<FriendlyByteBuf, ShareType> STREAM_CODEC;

        static {
            STREAM_CODEC = NetworkHelper.enumStreamCodec(ShareType.class);
        }
    }
}

