/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.serialize;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mrcrayfish.framework.api.serialize.DataArray;
import com.mrcrayfish.framework.api.serialize.DataBoolean;
import com.mrcrayfish.framework.api.serialize.DataNumber;
import com.mrcrayfish.framework.api.serialize.DataObject;
import com.mrcrayfish.framework.api.serialize.DataString;
import com.mrcrayfish.framework.api.serialize.DataType;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public abstract sealed class DataEntry
permits DataObject, DataArray, DataString, DataNumber, DataBoolean {
    private UUID id;
    private final DataType type;

    protected DataEntry(DataType type) {
        this.type = type;
    }

    public UUID getId() {
        if (this.id == null) {
            this.id = UUID.randomUUID();
        }
        return this.id;
    }

    public final DataType getType() {
        return this.type;
    }

    @Nullable
    static DataEntry convertElement(JsonElement element) {
        if (element.isJsonObject()) {
            return new DataObject(element.getAsJsonObject());
        }
        if (element.isJsonArray()) {
            return new DataArray(element.getAsJsonArray());
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isString()) {
                return new DataString(primitive.getAsString());
            }
            if (primitive.isNumber()) {
                return new DataNumber(primitive.getAsNumber());
            }
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean() ? DataBoolean.TRUE : DataBoolean.FALSE;
            }
        }
        return null;
    }
}

