/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.flightapi.mixin;

import dev.denismasterherobrine.flightapi.manager.FlightManager;
import dev.denismasterherobrine.flightapi.manager.IFlightPlayerAbilities;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Abilities.class})
public abstract class MixinPlayerAbilities
implements IFlightPlayerAbilities {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"FlightAPI/MixinPlayerAbilities");
    @Shadow
    public boolean flying;
    @Shadow
    public boolean mayfly;
    @Unique
    private Player flightapi$owner;

    @Override
    public Player getFlightOwner() {
        return this.flightapi$owner;
    }

    @Override
    public void setFlightOwner(Player player) {
        this.flightapi$owner = player;
    }

    @Redirect(method={"loadSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at=@At(value="FIELD", target="Lnet/minecraft/world/entity/player/Abilities;flying:Z", opcode=181))
    private void flightapi$redirectFlyingSet(Abilities instance, boolean newValue) {
        Player owner = this.getFlightOwner();
        if (owner == null) {
            this.flying = newValue;
            LOGGER.debug("[MixinPlayerAbilities] No owner found, setting flying={} as Vanilla", (Object)newValue);
            return;
        }
        String currentOwner = FlightManager.getInstance().getCurrentOwner(owner.getGameProfile().getId()).orElse(null);
        if (currentOwner == null) {
            this.flying = newValue;
            LOGGER.debug("[MixinPlayerAbilities] No FlightAPI owner, letting NBT set flying={}", (Object)newValue);
        } else {
            LOGGER.debug("[MixinPlayerAbilities] Flight is owned by {}, ignoring NBT flying={}", (Object)currentOwner, (Object)newValue);
        }
    }

    @Redirect(method={"loadSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at=@At(value="FIELD", target="Lnet/minecraft/world/entity/player/Abilities;mayfly:Z", opcode=181))
    private void flightapi$redirectAllowFlyingSet(Abilities instance, boolean newValue) {
        Player owner = this.getFlightOwner();
        if (owner == null) {
            this.mayfly = newValue;
            LOGGER.debug("[MixinPlayerAbilities] No owner found, setting allowFlying={} as Vanilla", (Object)newValue);
            return;
        }
        String currentOwner = FlightManager.getInstance().getCurrentOwner(owner.getGameProfile().getId()).orElse(null);
        if (currentOwner == null) {
            this.mayfly = newValue;
            LOGGER.debug("[MixinPlayerAbilities] No FlightApi owner, letting NBT set allowFlying={}", (Object)newValue);
        } else {
            LOGGER.debug("[MixinPlayerAbilities] Flight owned by {}, ignoring NBT allowFlying={}", (Object)currentOwner, (Object)newValue);
        }
    }
}

