/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.flightapi.manager;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlightManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"FlightManager");
    private static final FlightManager INSTANCE = new FlightManager();
    private final Map<UUID, Queue<String>> flightQueues = new HashMap<UUID, Queue<String>>();
    private final Map<UUID, String> currentOwners = new HashMap<UUID, String>();

    private FlightManager() {
    }

    public static FlightManager getInstance() {
        return INSTANCE;
    }

    public synchronized boolean requestFlightControl(String modId, ServerPlayer player) {
        if (player == null) {
            LOGGER.warn("[FlightManager] Player is null, can't request flight");
            return false;
        }
        if (modId == null || modId.isBlank()) {
            LOGGER.warn("[FlightManager] Invalid modId! modId cannot be null or blank on request.");
            return false;
        }
        UUID playerUuid = player.getGameProfile().getId();
        this.flightQueues.putIfAbsent(playerUuid, new LinkedList());
        Queue<String> queue = this.flightQueues.get(playerUuid);
        String currentOwner = this.currentOwners.get(playerUuid);
        if (modId.equals(currentOwner)) {
            LOGGER.info("[FlightManager] {} already owns flight for {}", (Object)modId, (Object)playerUuid);
            this.setPlayerFlightEnabled(player, true);
            return true;
        }
        if (currentOwner == null) {
            this.currentOwners.put(playerUuid, modId);
            LOGGER.info("[FlightManager] {} got flight control immediately for {}", (Object)modId, (Object)playerUuid);
            this.setPlayerFlightEnabled(player, true);
            return true;
        }
        if (!queue.contains(modId)) {
            queue.offer(modId);
            LOGGER.info("[FlightManager] {} queued for flight, current owner = {}", (Object)modId, (Object)currentOwner);
        }
        return false;
    }

    public synchronized void releaseFlightControl(String modId, ServerPlayer player) {
        if (player == null) {
            LOGGER.warn("[FlightManager] Player is null, can't release flight");
            return;
        }
        if (modId == null || modId.isBlank()) {
            LOGGER.warn("[FlightManager] Invalid modId! modId cannot be null or blank on release.");
            return;
        }
        UUID playerUuid = player.getGameProfile().getId();
        String currentOwner = this.currentOwners.get(playerUuid);
        if (currentOwner == null) {
            return;
        }
        if (!currentOwner.equals(modId)) {
            return;
        }
        this.currentOwners.remove(playerUuid);
        Queue<String> queue = this.flightQueues.get(playerUuid);
        if (queue == null || queue.isEmpty()) {
            this.setPlayerFlightEnabled(player, false);
            LOGGER.debug("[FlightManager] No next mod in queue. Flight disabled for {}", (Object)playerUuid);
            return;
        }
        String nextOwner = queue.poll();
        this.currentOwners.put(playerUuid, nextOwner);
        LOGGER.debug("[FlightManager] {} took flight control for {}", (Object)nextOwner, (Object)playerUuid);
        this.setPlayerFlightEnabled(player, true);
    }

    public synchronized Optional<String> getCurrentOwner(UUID playerUuid) {
        return Optional.ofNullable(this.currentOwners.get(playerUuid));
    }

    public void setPlayerFlightEnabled(ServerPlayer player, boolean enabled) {
        if (player == null) {
            LOGGER.debug("[FlightManager] Player not found on server.");
            return;
        }
        boolean isSpectator = player.isSpectator();
        boolean isCreative = player.getAbilities().instabuild;
        boolean bl = player.getAbilities().mayfly = enabled || isSpectator || isCreative;
        if (isSpectator || enabled) {
            player.getAbilities().flying = true;
        } else if (!isCreative) {
            player.getAbilities().flying = false;
        }
        player.onUpdateAbilities();
        LOGGER.debug("[FlightManager] setPlayerFlightEnabled({}, {}) done", (Object)player.getGameProfile().getId(), (Object)enabled);
    }

    public synchronized Optional<List<String>> getFlightQueueSnapshot(UUID playerUuid) {
        Queue<String> queue = this.flightQueues.get(playerUuid);
        return queue == null ? Optional.empty() : Optional.of(List.copyOf(queue));
    }

    public synchronized void cancelQueuedRequest(String modId, UUID playerUuid) {
        Queue<String> queue = this.flightQueues.get(playerUuid);
        if (queue != null) {
            queue.remove(modId);
        }
    }

    public synchronized void purgePlayer(UUID playerUuid) {
        this.currentOwners.remove(playerUuid);
        this.flightQueues.remove(playerUuid);
    }
}

