/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.flightapi.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.denismasterherobrine.flightapi.api.FlightAPI;
import dev.denismasterherobrine.flightapi.manager.FlightManager;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlightAPICommand {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"FlightManager");

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)Commands.literal((String)"flightapi").requires(src -> src.hasPermission(2));
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"status").executes(ctx -> FlightAPICommand.status((CommandContext<CommandSourceStack>)ctx, FlightAPICommand.selfOrError((CommandContext<CommandSourceStack>)ctx)))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> FlightAPICommand.status((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player")))));
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"owner").executes(ctx -> FlightAPICommand.owner((CommandContext<CommandSourceStack>)ctx, FlightAPICommand.selfOrError((CommandContext<CommandSourceStack>)ctx)))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> FlightAPICommand.owner((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player")))));
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"queue").executes(ctx -> FlightAPICommand.queue((CommandContext<CommandSourceStack>)ctx, FlightAPICommand.selfOrError((CommandContext<CommandSourceStack>)ctx)))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> FlightAPICommand.queue((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player")))));
        root.then(Commands.literal((String)"release").then(((RequiredArgumentBuilder)Commands.argument((String)"modId", (ArgumentType)StringArgumentType.word()).executes(ctx -> FlightAPICommand.release((CommandContext<CommandSourceStack>)ctx, FlightAPICommand.selfOrError((CommandContext<CommandSourceStack>)ctx), StringArgumentType.getString((CommandContext)ctx, (String)"modId")))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> FlightAPICommand.release((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"modId"))))));
        root.then(Commands.literal((String)"cancel").then(((RequiredArgumentBuilder)Commands.argument((String)"modId", (ArgumentType)StringArgumentType.word()).executes(ctx -> FlightAPICommand.cancel((CommandContext<CommandSourceStack>)ctx, FlightAPICommand.selfOrError((CommandContext<CommandSourceStack>)ctx), StringArgumentType.getString((CommandContext)ctx, (String)"modId")))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> FlightAPICommand.cancel((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"modId"))))));
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"purge").executes(ctx -> FlightAPICommand.purge((CommandContext<CommandSourceStack>)ctx, FlightAPICommand.selfOrError((CommandContext<CommandSourceStack>)ctx)))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> FlightAPICommand.purge((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player")))));
        dispatcher.register(root);
        LOGGER.info("[FlightAPI] commands registered");
    }

    private static int status(CommandContext<CommandSourceStack> ctx, ServerPlayer p) {
        UUID id = p.getUUID();
        String name = p.getGameProfile().getName();
        Optional<String> owner = FlightAPI.getCurrentOwner(id);
        List queue = FlightAPI.getFlightQueue(id).orElse(List.of());
        boolean creative = p.getAbilities().instabuild;
        boolean spectator = p.isSpectator();
        boolean allowFlying = p.getAbilities().mayfly;
        boolean flying = p.getAbilities().flying;
        MutableComponent msg = Component.literal((String)"FlightAPI status for ").append((Component)Component.literal((String)name).withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)"\nOwner: ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)String.valueOf(owner.orElse(null))).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)"\nQueue: ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)queue.toString()).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)"\nallowFlying=").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)String.valueOf(allowFlying)).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)"  flying=").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)String.valueOf(flying)).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)"\ncreative=").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)String.valueOf(creative)).withStyle(ChatFormatting.GOLD)).append((Component)Component.literal((String)"  spectator=").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)String.valueOf(spectator)).withStyle(ChatFormatting.GOLD));
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> FlightAPICommand.lambda$status$13((Component)msg), false);
        LOGGER.info("[FlightAPI] status: player={} owner='{}' queue={} allowFlying={} flying={} creative={} spectator={}", new Object[]{name, owner.orElse(null), queue, allowFlying, flying, creative, spectator});
        return 1;
    }

    private static int owner(CommandContext<CommandSourceStack> ctx, ServerPlayer player) {
        String owner = FlightAPI.getCurrentOwner(player.getUUID()).orElse("No flight owner found for player " + String.valueOf(player.getName()));
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Owner: ").append((Component)Component.literal((String)owner).withStyle(ChatFormatting.YELLOW)), true);
        return 1;
    }

    private static int queue(CommandContext<CommandSourceStack> ctx, ServerPlayer player) {
        List queue = FlightAPI.getFlightQueue(player.getUUID()).orElse(List.of());
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Flight queue for " + player.getName().getString() + ": ")).append((Component)Component.literal((String)String.join((CharSequence)", ", queue)).withStyle(ChatFormatting.YELLOW)), true);
        return 1;
    }

    private static int release(CommandContext<CommandSourceStack> ctx, ServerPlayer player, String modId) {
        FlightAPI.releaseFlight(modId, player);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Attempted to release flight control for " + player.getName().getString() + " by " + modId)).withStyle(ChatFormatting.GREEN), true);
        return 1;
    }

    private static int cancel(CommandContext<CommandSourceStack> ctx, ServerPlayer player, String modId) {
        FlightAPI.cancelFlightRequest(modId, player.getUUID());
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Attempted to cancel flight request for " + player.getName().getString() + " by " + modId)).withStyle(ChatFormatting.RED), true);
        return 1;
    }

    private static int purge(CommandContext<CommandSourceStack> ctx, ServerPlayer player) {
        FlightManager.getInstance().purgePlayer(player.getUUID());
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Purged flight data for " + player.getName().getString())).withStyle(ChatFormatting.RED), true);
        return 1;
    }

    private static ServerPlayer selfOrError(CommandContext<CommandSourceStack> ctx) {
        try {
            return ((CommandSourceStack)ctx.getSource()).getPlayer();
        }
        catch (Exception noPlayer) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Must specify <player> when running from console."));
            throw new IllegalStateException("No player in context");
        }
    }

    private static /* synthetic */ Component lambda$status$13(Component msg) {
        return msg;
    }
}

