/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.flightapi.api;

import dev.denismasterherobrine.flightapi.manager.FlightManager;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlightAPI {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"FlightAPI");
    private static final FlightManager FLIGHT_MANAGER = FlightManager.getInstance();

    public static boolean requestFlight(String modId, ServerPlayer player) {
        LOGGER.debug("[FlightAPI] {} requested flight for player {}", (Object)modId, (Object)player);
        return FLIGHT_MANAGER.requestFlightControl(modId, player);
    }

    public static void releaseFlight(String modId, ServerPlayer player) {
        LOGGER.debug("[FlightAPI] {} released flight for player {}", (Object)modId, (Object)player);
        FLIGHT_MANAGER.releaseFlightControl(modId, player);
    }

    public static Optional<String> getCurrentOwner(UUID playerUuid) {
        return FLIGHT_MANAGER.getCurrentOwner(playerUuid);
    }

    public static Optional<List<String>> getFlightQueue(UUID playerUuid) {
        return FLIGHT_MANAGER.getFlightQueueSnapshot(playerUuid);
    }

    public static void cancelFlightRequest(String modId, UUID playerUuid) {
        LOGGER.debug("[FlightAPI] Cancelling flight request for mod {} and player {}", (Object)modId, (Object)playerUuid);
        FLIGHT_MANAGER.cancelQueuedRequest(modId, playerUuid);
    }
}

