/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.expandeddelight.data;

import com.google.common.collect.Sets;
import ianm1647.expandeddelight.common.block.EDCropBlock;
import ianm1647.expandeddelight.common.registry.EDBlocks;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import vectorwing.farmersdelight.common.block.CabinetBlock;
import vectorwing.farmersdelight.common.block.FeastBlock;
import vectorwing.farmersdelight.common.block.PieBlock;

public class EDBlockStates
extends BlockStateProvider {
    private static final int DEFAULT_ANGLE_OFFSET = 180;

    public EDBlockStates(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "expandeddelight", existingFileHelper);
    }

    private String blockName(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
    }

    public ResourceLocation resourceBlock(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"expandeddelight", (String)("block/" + path));
    }

    public ModelFile existingModel(Block block) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(this.blockName(block)), this.models().existingFileHelper);
    }

    public ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(path), this.models().existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.saplingBlock(EDBlocks.CINNAMON_SAPLING.get());
        this.leavesBlock(EDBlocks.CINNAMON_LEAVES.get());
        this.logBlock((RotatedPillarBlock)EDBlocks.CINNAMON_LOG.get());
        this.axisBlock((RotatedPillarBlock)EDBlocks.CINNAMON_WOOD.get(), this.blockTexture(EDBlocks.CINNAMON_LOG.get()), this.blockTexture(EDBlocks.CINNAMON_LOG.get()));
        this.logBlock((RotatedPillarBlock)EDBlocks.CINNAMON_STRIPPED_LOG.get());
        this.axisBlock((RotatedPillarBlock)EDBlocks.CINNAMON_STRIPPED_WOOD.get(), this.blockTexture(EDBlocks.CINNAMON_STRIPPED_LOG.get()), this.blockTexture(EDBlocks.CINNAMON_STRIPPED_LOG.get()));
        this.simpleBlock(EDBlocks.CINNAMON_PLANKS.get());
        this.stairsBlock((StairBlock)EDBlocks.CINNAMON_STAIRS.get(), this.blockTexture(EDBlocks.CINNAMON_PLANKS.get()));
        this.slabBlock((SlabBlock)EDBlocks.CINNAMON_SLAB.get(), this.blockTexture(EDBlocks.CINNAMON_PLANKS.get()), this.blockTexture(EDBlocks.CINNAMON_PLANKS.get()));
        this.fenceBlock((FenceBlock)EDBlocks.CINNAMON_FENCE.get(), this.blockTexture(EDBlocks.CINNAMON_PLANKS.get()));
        this.fenceGateBlock((FenceGateBlock)EDBlocks.CINNAMON_FENCE_GATE.get(), this.blockTexture(EDBlocks.CINNAMON_PLANKS.get()));
        ResourceLocation doorTop = ResourceLocation.fromNamespaceAndPath((String)"expandeddelight", (String)"block/cinnamon_door_top");
        ResourceLocation doorBottom = ResourceLocation.fromNamespaceAndPath((String)"expandeddelight", (String)"block/cinnamon_door_bottom");
        this.doorBlockWithRenderType((DoorBlock)EDBlocks.CINNAMON_DOOR.get(), doorBottom, doorTop, "cutout");
        ResourceLocation trapdoor = ResourceLocation.fromNamespaceAndPath((String)"expandeddelight", (String)"block/cinnamon_trapdoor");
        this.trapdoorBlockWithRenderType((TrapDoorBlock)EDBlocks.CINNAMON_TRAPDOOR.get(), trapdoor, true, "cutout");
        this.trapdoorItem(EDBlocks.CINNAMON_TRAPDOOR.get(), "_bottom");
        this.pressurePlateBlock((PressurePlateBlock)EDBlocks.CINNAMON_PRESSURE_PLATE.get(), this.blockTexture(EDBlocks.CINNAMON_PLANKS.get()));
        this.buttonBlock((ButtonBlock)EDBlocks.CINNAMON_BUTTON.get(), this.blockTexture(EDBlocks.CINNAMON_PLANKS.get()));
        HashSet signs = Sets.newHashSet((Object[])new Block[]{EDBlocks.CINNAMON_SIGN.get(), EDBlocks.CINNAMON_WALL_SIGN.get(), EDBlocks.CINNAMON_WALL_HANGING_SIGN.get(), EDBlocks.CINNAMON_CEILING_HANGING_SIGN.get()});
        for (Block sign : signs) {
            this.simpleBlock(sign, this.existingModel(EDBlocks.CINNAMON_SIGN.get()));
        }
        this.cabinetBlock(EDBlocks.CINNAMON_CABINET.get(), "cinnamon");
        this.customHorizontalBlock(EDBlocks.JUICER.get(), $ -> this.existingModel(EDBlocks.JUICER.get()), new Property[0]);
        this.simpleBlock(EDBlocks.CASK.get(), this.existingModel(EDBlocks.CASK.get()));
        this.simpleBlock(EDBlocks.MILK_CASK.get(), this.existingModel(EDBlocks.MILK_CASK.get()));
        this.simpleBlock(EDBlocks.CHEESE_CASK.get(), this.existingModel(EDBlocks.CHEESE_CASK.get()));
        this.simpleBlock(EDBlocks.GOAT_MILK_CASK.get(), this.existingModel(EDBlocks.GOAT_MILK_CASK.get()));
        this.simpleBlock(EDBlocks.GOAT_CHEESE_CASK.get(), this.existingModel(EDBlocks.GOAT_CHEESE_CASK.get()));
        this.pieBlock(EDBlocks.CHEESE_WHEEL.get());
        this.pieBlock(EDBlocks.GOAT_CHEESE_WHEEL.get());
        this.pieBlock(EDBlocks.CRANBERRY_COBBLER.get());
        this.pieBlock(EDBlocks.HONEYED_GOAT_CHEESE_TART.get());
        this.simpleBlock(EDBlocks.ASPARAGUS_CRATE.get(), this.existingModel(EDBlocks.ASPARAGUS_CRATE.get()));
        this.simpleBlock(EDBlocks.SWEET_POTATO_CRATE.get(), this.existingModel(EDBlocks.SWEET_POTATO_CRATE.get()));
        this.simpleBlock(EDBlocks.CHILI_PEPPER_CRATE.get(), this.existingModel(EDBlocks.CHILI_PEPPER_CRATE.get()));
        this.simpleBlock(EDBlocks.CRANBERRY_BAG.get(), this.existingModel(EDBlocks.CRANBERRY_BAG.get()));
        this.wildCropBlock(EDBlocks.WILD_ASPARAGUS.get());
        this.wildCropBlock(EDBlocks.WILD_SWEET_POTATO.get());
        this.wildCropBlock(EDBlocks.WILD_CHILI_PEPPER.get());
        this.wildCropBlock(EDBlocks.WILD_PEANUTS.get());
        this.simpleBlock(EDBlocks.SALT_ORE.get(), this.existingModel(EDBlocks.SALT_ORE.get()));
        this.simpleBlock(EDBlocks.DEEPSLATE_SALT_ORE.get(), this.existingModel(EDBlocks.DEEPSLATE_SALT_ORE.get()));
        this.customStageBlock(EDBlocks.ASPARAGUS_CROP.get(), this.mcLoc("crop"), "crop", EDCropBlock.AGE, Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7), new Property[0]);
        this.customStageBlock(EDBlocks.SWEET_POTATO_CROP.get(), this.mcLoc("crop"), "crop", EDCropBlock.AGE, Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7), new Property[0]);
        this.customStageBlock(EDBlocks.CHILI_PEPPER_CROP.get(), this.mcLoc("crop"), "crop", EDCropBlock.AGE, Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7), new Property[0]);
        this.customStageBlock(EDBlocks.PEANUT_CROP.get(), this.mcLoc("crop"), "crop", EDCropBlock.AGE, Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7), new Property[0]);
    }

    public ConfiguredModel[] cubeRandomRotation(Block block, String suffix) {
        String var10000 = this.blockName(block);
        String formattedName = var10000 + (String)(suffix.isEmpty() ? "" : "_" + suffix);
        return ConfiguredModel.allYRotations((ModelFile)this.models().cubeAll(formattedName, this.resourceBlock(formattedName)), (int)0, (boolean)false);
    }

    public void customDirectionalBlock(Block block, Function<BlockState, ModelFile> modelFunc, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(dir == Direction.DOWN ? 180 : (dir.getAxis().isHorizontal() ? 90 : 0)).rotationY(dir.getAxis().isVertical() ? 0 : ((int)dir.toYRot() + 180) % 360).build();
        }, ignored);
    }

    public void customHorizontalBlock(Block block, Function<BlockState, ModelFile> modelFunc, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY(((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 180) % 360).build(), ignored);
    }

    public void stageBlock(Block block, IntegerProperty ageProperty, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int ageSuffix = (Integer)state.getValue((Property)ageProperty);
            String var10000 = this.blockName(block);
            String stageName = var10000 + "_stage" + ageSuffix;
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(stageName, this.resourceBlock(stageName))).renderType("cutout")).build();
        }, ignored);
    }

    public void customStageBlock(Block block, @Nullable ResourceLocation parent, String textureKey, IntegerProperty ageProperty, List<Integer> suffixes, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int ageSuffix = (Integer)state.getValue((Property)ageProperty);
            String var10000 = this.blockName(block);
            String stageName = var10000 + "_stage";
            stageName = stageName + (suffixes.isEmpty() ? ageSuffix : (Integer)suffixes.get(Math.min(suffixes.size(), ageSuffix)));
            return parent == null ? ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(stageName, this.resourceBlock(stageName))).renderType("cutout")).build() : ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().singleTexture(stageName, parent, textureKey, this.resourceBlock(stageName))).renderType("cutout")).build();
        }, ignored);
    }

    public void wildCropBlock(Block block) {
        this.wildCropBlock(block, false);
    }

    public void wildCropBlock(Block block, boolean isBushCrop) {
        if (isBushCrop) {
            this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().singleTexture(this.blockName(block), this.resourceBlock("bush_crop"), "crop", this.resourceBlock(this.blockName(block)))).renderType("cutout"));
        } else {
            this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(this.blockName(block), this.resourceBlock(this.blockName(block)))).renderType("cutout"));
        }
    }

    public void cabinetBlock(Block block, String woodType) {
        this.horizontalBlock(block, state -> {
            String suffix = (Boolean)state.getValue((Property)CabinetBlock.OPEN) != false ? "_open" : "";
            return this.models().orientable(this.blockName(block) + suffix, this.resourceBlock(woodType + "_cabinet_side"), this.resourceBlock(woodType + "_cabinet_front" + suffix), this.resourceBlock(woodType + "_cabinet_top"));
        });
    }

    public void feastBlock(FeastBlock block) {
        this.getVariantBuilder((Block)block).forAllStates(state -> {
            IntegerProperty servingsProperty = block.getServingsProperty();
            int servings = (Integer)state.getValue((Property)servingsProperty);
            Object suffix = "_stage" + (block.getMaxServings() - servings);
            if (servings == 0) {
                suffix = block.hasLeftovers ? "_leftover" : "_stage" + (servingsProperty.getPossibleValues().toArray().length - 2);
            }
            ConfiguredModel.Builder var10000 = ConfiguredModel.builder();
            String var10002 = this.blockName((Block)block);
            return var10000.modelFile(this.existingModel(var10002 + (String)suffix)).rotationY(((int)((Direction)state.getValue((Property)FeastBlock.FACING)).toYRot() + 180) % 360).build();
        });
    }

    public void doublePlantBlock(Block block) {
        ConfiguredModel.Builder var10000 = this.getVariantBuilder(block).partialState().with((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER).modelForState();
        BlockModelProvider var10001 = this.models();
        String var10002 = this.blockName(block) + "_bottom";
        String var10004 = this.blockName(block);
        var10000 = ((VariantBlockStateBuilder)var10000.modelFile((ModelFile)((BlockModelBuilder)var10001.cross(var10002, this.resourceBlock(var10004 + "_bottom"))).renderType("cutout")).addModel()).partialState().with((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER).modelForState();
        var10001 = this.models();
        var10002 = this.blockName(block) + "_top";
        var10004 = this.blockName(block);
        var10000.modelFile((ModelFile)((BlockModelBuilder)var10001.cross(var10002, this.resourceBlock(var10004 + "_top"))).renderType("cutout")).addModel();
    }

    public void pieBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int bites = (Integer)state.getValue((Property)PieBlock.BITES);
            Object suffix = bites > 0 ? "_slice" + bites : "";
            ConfiguredModel.Builder var10000 = ConfiguredModel.builder();
            String var10002 = this.blockName(block);
            return var10000.modelFile(this.existingModel(var10002 + (String)suffix)).rotationY(((int)((Direction)state.getValue((Property)PieBlock.FACING)).toYRot() + 180) % 360).build();
        });
    }

    private void saplingBlock(Block block) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(BuiltInRegistries.BLOCK.getKey((Object)block).getPath(), this.blockTexture(block))).renderType("cutout"));
    }

    private void leavesBlock(Block block) {
        this.simpleBlockWithItem(block, (ModelFile)((BlockModelBuilder)this.models().singleTexture(BuiltInRegistries.BLOCK.getKey((Object)block).getPath(), ResourceLocation.parse((String)"minecraft:block/leaves"), "all", this.blockTexture(block))).renderType("cutout"));
    }

    public void trapdoorItem(Block block, String appendix) {
        this.simpleBlockItem(block, (ModelFile)new ModelFile.UncheckedModelFile("expandeddelight:block/" + BuiltInRegistries.BLOCK.getKey((Object)block).getPath() + appendix));
    }
}

