/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.recipes;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import lekavar.lma.drinkbeer.recipes.IBrewingInventory;
import lekavar.lma.drinkbeer.registries.RecipeRegistry;
import lekavar.lma.drinkbeer.utils.DrinkBeerCodes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class BrewingRecipe
implements Recipe<IBrewingInventory> {
    private final NonNullList<Ingredient> input;
    private final ItemStack cup;
    private final int brewingTime;
    private final ItemStack result;

    public BrewingRecipe(NonNullList<Ingredient> input, ItemStack cup, int brewingTime, ItemStack result) {
        this.input = input;
        this.cup = cup;
        this.brewingTime = brewingTime;
        this.result = result;
    }

    @Deprecated
    public NonNullList<Ingredient> getIngredient() {
        NonNullList result = NonNullList.create();
        result.addAll(this.input);
        return result;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList result = NonNullList.create();
        result.addAll(this.input);
        return result;
    }

    @Deprecated
    public ItemStack geBeerCup() {
        return this.cup.copy();
    }

    public ItemStack getBeerCup() {
        return this.cup.copy();
    }

    public boolean matches(IBrewingInventory pContainer, Level pLevel) {
        ArrayList testTarget = Lists.newArrayList(this.input);
        List<ItemStack> tested = pContainer.getIngredients();
        if (tested.size() < 4) {
            return false;
        }
        for (ItemStack itemStack : tested) {
            int i = this.getLatestMatched(testTarget, itemStack);
            if (i == -1) {
                return false;
            }
            testTarget.remove(i);
        }
        return testTarget.isEmpty();
    }

    public ItemStack assemble(IBrewingInventory iBrewingInventory, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    private int getLatestMatched(List<Ingredient> testTarget, ItemStack tested) {
        for (int i = 0; i < testTarget.size(); ++i) {
            if (!testTarget.get(i).test(tested)) continue;
            return i;
        }
        return -1;
    }

    public boolean canCraftInDimensions(int p_194133_1_, int p_194133_2_) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public ItemStack getResultItemNoRegistryAccess() {
        return this.result.copy();
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return RecipeRegistry.RECIPE_SERIALIZER_BREWING.get();
    }

    public RecipeType<?> getType() {
        return RecipeRegistry.RECIPE_TYPE_BREWING.get();
    }

    public int getRequiredCupCount() {
        return this.cup.getCount();
    }

    public boolean isCupQualified(IBrewingInventory inventory) {
        return inventory.getCup().getItem() == this.cup.getItem() && inventory.getCup().getCount() >= this.cup.getCount();
    }

    public int getBrewingTime() {
        return this.brewingTime;
    }

    public static class Serializer
    implements RecipeSerializer<BrewingRecipe> {
        public static final MapCodec<BrewingRecipe> CODEC = RecordCodecBuilder.mapCodec(ins -> ins.group((App)DrinkBeerCodes.NON_NULL_LIST_4_INGREDIENT_CODEC.fieldOf("ingredients").forGetter(BrewingRecipe::getIngredients), (App)ItemStack.CODEC.fieldOf("cup").forGetter(BrewingRecipe::getBeerCup), (App)Codec.INT.fieldOf("brewing_time").forGetter(BrewingRecipe::getBrewingTime), (App)ItemStack.CODEC.fieldOf("result").forGetter(BrewingRecipe::getResultItemNoRegistryAccess)).apply((Applicative)ins, BrewingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BrewingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static BrewingRecipe fromNetwork(RegistryFriendlyByteBuf packetBuffer) {
            int i = packetBuffer.readVarInt();
            NonNullList ingredients = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            ingredients.replaceAll(_it -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)packetBuffer));
            ItemStack cup = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)packetBuffer);
            int brewingTime = packetBuffer.readVarInt();
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)packetBuffer);
            return new BrewingRecipe((NonNullList<Ingredient>)ingredients, cup, brewingTime, result);
        }

        public static void toNetwork(RegistryFriendlyByteBuf packetBuffer, BrewingRecipe brewingRecipe) {
            packetBuffer.writeVarInt(brewingRecipe.input.size());
            for (Ingredient ingredient : brewingRecipe.input) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)packetBuffer, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)packetBuffer, (Object)brewingRecipe.cup);
            packetBuffer.writeVarInt(brewingRecipe.brewingTime);
            ItemStack.STREAM_CODEC.encode((Object)packetBuffer, (Object)brewingRecipe.result);
        }

        public MapCodec<BrewingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BrewingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

