/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.managers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lekavar.lma.drinkbeer.effects.DrunkStatusEffect;
import lekavar.lma.drinkbeer.effects.NightHowlStatusEffect;
import lekavar.lma.drinkbeer.items.MixedBeerBlockItem;
import lekavar.lma.drinkbeer.managers.SpiceAndFlavorManager;
import lekavar.lma.drinkbeer.registries.DamageRegistry;
import lekavar.lma.drinkbeer.registries.DataComponentTypeRegistry;
import lekavar.lma.drinkbeer.registries.ItemRegistry;
import lekavar.lma.drinkbeer.utils.beer.Beers;
import lekavar.lma.drinkbeer.utils.dataComponent.SpiceData;
import lekavar.lma.drinkbeer.utils.mixedbeer.Flavors;
import lekavar.lma.drinkbeer.utils.mixedbeer.MixedBeerOnUsing;
import lekavar.lma.drinkbeer.utils.mixedbeer.Spices;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public class MixedBeerManager {
    public static ItemStack genMixedBeerItemStack(int beerId, int ... spiceIds) {
        ArrayList<Integer> spiceList = new ArrayList<Integer>();
        for (int spiceId : spiceIds) {
            spiceList.add(spiceId);
        }
        return MixedBeerManager.genMixedBeerItemStack(beerId, spiceList);
    }

    public static ItemStack genMixedBeerItemStack(int beerId, List<Integer> spiceList) {
        ItemStack resultStack = new ItemStack((ItemLike)ItemRegistry.MIXED_BEER.get(), 1);
        resultStack.set(DataComponentTypeRegistry.BEER_ID_COMPONENT, (Object)beerId);
        spiceList = MixedBeerManager.removeIllegalSpiceId(spiceList);
        resultStack.set(DataComponentTypeRegistry.SPICE_COMPONENT, (Object)SpiceData.fromSpiceList(spiceList));
        return resultStack;
    }

    private static List<Integer> removeIllegalSpiceId(List<Integer> spiceList) {
        return spiceList.stream().filter(value -> value.compareTo(0) > 0 && value.compareTo(Spices.size()) <= 0).collect(Collectors.toList());
    }

    public static int getBeerId(ItemStack itemStack) {
        if (itemStack.getItem() instanceof MixedBeerBlockItem) {
            return (Integer)itemStack.get(DataComponentTypeRegistry.BEER_ID_COMPONENT);
        }
        return 0;
    }

    public static List<Integer> getSpiceList(ItemStack itemStack) {
        SpiceData data;
        ArrayList<Integer> spiceList = new ArrayList<Integer>();
        if (itemStack.getItem() instanceof MixedBeerBlockItem && (data = (SpiceData)itemStack.get(DataComponentTypeRegistry.SPICE_COMPONENT)).spiceA() > 0) {
            spiceList.add(data.spiceA());
            if (data.spiceB() > 0) {
                spiceList.add(data.spiceB());
                if (data.spiceC() > 0) {
                    spiceList.add(data.spiceC());
                }
            }
        }
        return spiceList;
    }

    public static String getMixedBeerTranslationKey() {
        return ItemRegistry.MIXED_BEER.get().asItem().toString();
    }

    public static String getBaseBeerToolTipTranslationKey() {
        return "item.drinkbeer.mixed_beer.tooltip_base";
    }

    public static String getUnmixedToolTipTranslationKey() {
        return "item.drinkbeer.mixed_beer.tooltip_unmixed";
    }

    public static void useMixedBeer(ItemStack stack, Level world, LivingEntity user) {
        MixedBeerOnUsing mixedBeerOnUsing = new MixedBeerOnUsing();
        mixedBeerOnUsing.setBeer(Beers.byId(MixedBeerManager.getBeerId(stack)));
        mixedBeerOnUsing.addHunger(Objects.requireNonNull(mixedBeerOnUsing.getBeerItem().getFoodProperties(stack, null).nutrition()));
        List<Integer> spiceList = MixedBeerManager.getSpiceList(stack);
        mixedBeerOnUsing.setSpiceList(spiceList);
        Flavors combinedFlavor = SpiceAndFlavorManager.getCombinedFlavor(spiceList);
        if (combinedFlavor != null) {
            mixedBeerOnUsing.addFlavor(combinedFlavor);
        }
        mixedBeerOnUsing.addStatusEffect(MixedBeerManager.getBeerStatusEffectList(mixedBeerOnUsing.getBeerItem().getDefaultInstance(), world));
        SpiceAndFlavorManager.applyFlavorValue(mixedBeerOnUsing);
        DrunkStatusEffect.addStatusEffect(user, mixedBeerOnUsing.getDrunkValue());
        if (mixedBeerOnUsing.getBeer().equals((Object)Beers.BEER_MUG_NIGHT_HOWL_KVASS)) {
            NightHowlStatusEffect.playRandomHowlSound(world, user);
        }
        if (user instanceof Player && !((Player)user).isCreative()) {
            ((Player)user).getFoodData().eat(mixedBeerOnUsing.getHunger(), 0.0f);
        }
        if (user instanceof Player) {
            if (!((Player)user).isCreative()) {
                if (mixedBeerOnUsing.getHealth() < 0.0f) {
                    user.hurt(DamageRegistry.alcohol(world.registryAccess()), Math.abs(mixedBeerOnUsing.getHealth()));
                } else {
                    user.heal(mixedBeerOnUsing.getHealth());
                }
            }
        } else {
            user.setHealth(user.getHealth() + mixedBeerOnUsing.getHealth());
        }
        for (Pair<MobEffect, Integer> statusEffectPair : mixedBeerOnUsing.getStatusEffectList()) {
            user.addEffect(new MobEffectInstance(Holder.direct((Object)((MobEffect)statusEffectPair.getKey())), ((Integer)statusEffectPair.getValue()).intValue()));
        }
        SpiceAndFlavorManager.applyFlavorAction(mixedBeerOnUsing, world, user);
    }

    private static List<Pair<MobEffect, Integer>> getBeerStatusEffectList(ItemStack stack, Level world) {
        ArrayList<Pair<MobEffect, Integer>> resultStatusEffectList = new ArrayList<Pair<MobEffect, Integer>>();
        List possibleEffects = stack.getFoodProperties(null).effects();
        if (possibleEffects != null && !possibleEffects.isEmpty()) {
            for (FoodProperties.PossibleEffect possibleEffect : possibleEffects) {
                resultStatusEffectList.add((Pair<MobEffect, Integer>)Pair.of((Object)((MobEffect)possibleEffect.effect().getEffect().value()), (Object)possibleEffect.effect().getDuration()));
            }
        }
        if (stack.getItem().equals(Beers.BEER_MUG_NIGHT_HOWL_KVASS.getBeerItem())) {
            Pair<MobEffect, Integer> nightHowlStatusEffectPair = NightHowlStatusEffect.getStatusEffectPair(world);
            resultStatusEffectList.add(nightHowlStatusEffectPair);
        }
        return resultStatusEffectList;
    }

    public static int getActionedTimes(int index, Flavors targetAction, List<Flavors> actionList) {
        if (index == 0) {
            return 0;
        }
        int actionTime = 0;
        for (int i = 0; i < index; ++i) {
            if (!actionList.get(i).equals((Object)targetAction)) continue;
            ++actionTime;
        }
        return actionTime;
    }

    public static boolean hasActionedBefore(int index, Flavors targetAction, List<Flavors> actionList) {
        return MixedBeerManager.getActionedTimes(index, targetAction, actionList) != 0;
    }

    public static boolean hasActionAfter(int index, Flavors targetAction, List<Flavors> actionList) {
        if (actionList.size() - 1 == index) {
            return false;
        }
        for (int i = index + 1; i < actionList.size(); ++i) {
            if (!actionList.get(i).equals((Object)targetAction)) continue;
            return true;
        }
        return false;
    }
}

