/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import lekavar.lma.drinkbeer.gui.BeerBarrelMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class BeerBarrelScreen
extends AbstractContainerScreen<BeerBarrelMenu> {
    private final ResourceLocation BEER_BARREL_CONTAINER_RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"drinkbeer", (String)"textures/gui/container/beer_barrel.png");
    private final int textureWidth = 176;
    private final int textureHeight = 166;
    private Inventory inventory;

    public BeerBarrelScreen(BeerBarrelMenu screenContainer, Inventory inv, Component title) {
        super((AbstractContainerMenu)screenContainer, inv, title);
        this.imageWidth = 176;
        this.imageHeight = 166;
        this.inventory = inv;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.BEER_BARREL_CONTAINER_RESOURCE);
        int i = (this.width - this.getXSize()) / 2;
        int j = (this.height - this.getYSize()) / 2;
        guiGraphics.blit(this.BEER_BARREL_CONTAINER_RESOURCE, i, j, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.drawCenteredString(this.font, this.title, this.textureWidth / 2, this.titleLabelY, 0x404040);
        guiGraphics.drawString(this.font, this.inventory.getDisplayName(), this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
        String str = ((BeerBarrelMenu)this.menu).getIsBrewing() ? this.convertTickToTime(((BeerBarrelMenu)this.menu).getRemainingBrewingTime()) : this.convertTickToTime(((BeerBarrelMenu)this.menu).getStandardBrewingTime());
        guiGraphics.drawString(this.font, str, 128.0f, 54.0f, new Color(64, 64, 64, 255).getRGB(), false);
    }

    public String convertTickToTime(int tick) {
        Object result;
        if (tick > 0) {
            double time = tick / 20;
            int m = (int)(time / 60.0);
            int s = (int)(time % 60.0);
            result = m + ":" + s;
        } else {
            result = "";
        }
        return result;
    }
}

