/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.effects;

import java.util.Random;
import lekavar.lma.drinkbeer.registries.ItemRegistry;
import lekavar.lma.drinkbeer.registries.SoundEventRegistry;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public class NightHowlStatusEffect {
    private static final int BASE_NIGHT_VISION_TIME = 2400;

    public static void addStatusEffect(ItemStack stack, Level world, LivingEntity user) {
        if (stack.getItem() == ItemRegistry.BEER_MUG_NIGHT_HOWL_KVASS.get()) {
            user.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, NightHowlStatusEffect.getNightVisionTime(NightHowlStatusEffect.getMoonPhase(world))));
            NightHowlStatusEffect.playRandomHowlSound(world, user);
        }
    }

    public static Pair<MobEffect, Integer> getStatusEffectPair(Level world) {
        return Pair.of((Object)((MobEffect)MobEffects.NIGHT_VISION.value()), (Object)NightHowlStatusEffect.getNightVisionTime(NightHowlStatusEffect.getMoonPhase(world)));
    }

    public static void playRandomHowlSound(Level world, LivingEntity user) {
        if (!world.isClientSide) {
            world.playSound(null, user.blockPosition(), SoundEventRegistry.NIGHT_HOWL[new Random().nextInt(4)].get(), SoundSource.PLAYERS, 1.2f, 1.0f);
        }
    }

    private static int getNightVisionTime(int moonPhase) {
        return 2400 + (moonPhase == 0 ? Math.abs(moonPhase - 1 - 4) * 1200 : Math.abs(moonPhase - 4) * 1200);
    }

    private static int getMoonPhase(Level world) {
        try {
            long timeOfDay = world.getDayTime();
            return (int)(timeOfDay / 24000L % 8L + 8L) % 8;
        }
        catch (Exception e) {
            return 0;
        }
    }
}

