/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import lekavar.lma.drinkbeer.registries.BlockRegistry;
import lekavar.lma.drinkbeer.utils.mixedbeer.Spices;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SpiceBlock
extends HalfTransparentBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final VoxelShape DEFAULT_SHAPE = SpiceBlock.box((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)2.0, (double)10.5);
    public static final VoxelShape SPICE_FROZEN_PERSIMMON_SHAPE = SpiceBlock.box((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)3.5, (double)10.5);
    public static final VoxelShape SPICE_DRIED_SELAGINELLA = SpiceBlock.box((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)4.5, (double)10.5);

    public SpiceBlock() {
        super(BlockBehaviour.Properties.of().ignitedByLava().mapColor(MapColor.WOOD).strength(1.0f).pushReaction(PushReaction.DESTROY));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        if (((Object)((Object)this)).equals(BlockRegistry.SPICE_FROZEN_PERSIMMON.get())) {
            return SPICE_FROZEN_PERSIMMON_SHAPE;
        }
        if (((Object)((Object)this)).equals(BlockRegistry.SPICE_DRIED_SELAGINELLA.get())) {
            return SPICE_DRIED_SELAGINELLA;
        }
        return DEFAULT_SHAPE;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return direction == Direction.DOWN && !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            SimpleParticleType particle = Spices.byItem(this.asItem()).getFlavor().getParticle();
            double x = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + 0.3 + new Random().nextDouble() / 4.0;
            double z = (double)pos.getZ() + 0.5;
            if (particle != null) {
                level.addParticle((ParticleOptions)particle, x, y, z, 0.0, 0.0, 0.0);
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (level.getBlockState(pos.below()).getBlock() == Blocks.AIR) {
            return false;
        }
        return Block.canSupportCenter((LevelReader)level, (BlockPos)pos.below(), (Direction)Direction.UP);
    }
}

