/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.blocks;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import lekavar.lma.drinkbeer.blockentities.BartendingTableBlockEntity;
import lekavar.lma.drinkbeer.items.BeerMugItem;
import lekavar.lma.drinkbeer.items.MixedBeerBlockItem;
import lekavar.lma.drinkbeer.items.SpiceBlockItem;
import lekavar.lma.drinkbeer.registries.SoundEventRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BartendingTableBlock
extends BaseEntityBlock {
    public static final MapCodec<BartendingTableBlock> CODEC = BartendingTableBlock.simpleCodec(pro -> new BartendingTableBlock());
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty OPENED = BooleanProperty.create((String)"opened");
    public static final IntegerProperty TYPE = IntegerProperty.create((String)"type", (int)1, (int)2);
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.01, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public BartendingTableBlock() {
        super(BlockBehaviour.Properties.of().ignitedByLava().mapColor(MapColor.WOOD).strength(2.0f).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPENED, (Comparable)Boolean.valueOf(true))).setValue((Property)TYPE, (Comparable)Integer.valueOf(1)));
    }

    public VoxelShape getShape(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING}).add(new Property[]{OPENED}).add(new Property[]{TYPE});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BartendingTableBlockEntity(blockPos, blockState);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockentity;
        if (!world.isClientSide() && (blockentity = world.getBlockEntity(pos)) instanceof BartendingTableBlockEntity) {
            ItemEntity itementity;
            boolean flag;
            BartendingTableBlockEntity bartendingTableBlockEntity = (BartendingTableBlockEntity)blockentity;
            if (player.isShiftKeyDown()) {
                boolean currentOpenedState = (Boolean)state.getValue((Property)OPENED);
                world.playSound(null, pos, currentOpenedState ? SoundEventRegistry.BARTENDING_TABLE_CLOSE.get() : SoundEventRegistry.BARTENDING_TABLE_OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)OPENED, (Comparable)Boolean.valueOf(!currentOpenedState)));
                return InteractionResult.CONSUME;
            }
            ItemStack tryTake = bartendingTableBlockEntity.takeBeer(false);
            if (!tryTake.isEmpty() && !(flag = player.getInventory().add(tryTake)) && (itementity = player.drop(tryTake, false)) != null) {
                itementity.setNoPickUpDelay();
                itementity.setThrower((Entity)player);
            }
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!world.isClientSide()) {
            ItemStack itemStack = player.getItemInHand(hand);
            BlockEntity blockentity = world.getBlockEntity(pos);
            if (blockentity instanceof BartendingTableBlockEntity) {
                BartendingTableBlockEntity bartendingTableBlockEntity = (BartendingTableBlockEntity)blockentity;
                if (itemStack.getItem() instanceof MixedBeerBlockItem || itemStack.getItem() instanceof BeerMugItem) {
                    ItemStack placeIn = itemStack.copy();
                    placeIn.setCount(1);
                    boolean result = bartendingTableBlockEntity.placeBeer(placeIn);
                    if (result) {
                        world.playSound(null, pos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        if (!player.getAbilities().instabuild) {
                            itemStack.shrink(1);
                        }
                    }
                    return ItemInteractionResult.CONSUME;
                }
                if (itemStack.getItem() instanceof SpiceBlockItem) {
                    ItemStack placeIn = itemStack.copy();
                    placeIn.setCount(1);
                    boolean result = bartendingTableBlockEntity.putSpice(placeIn);
                    if (result) {
                        world.playSound(null, pos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        if (!player.getAbilities().instabuild) {
                            itemStack.shrink(1);
                        }
                    }
                }
                return ItemInteractionResult.CONSUME;
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    public RenderShape getRenderShape(BlockState p_49232_) {
        return RenderShape.MODEL;
    }
}

