/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.frames.timber;

import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.TimberFrameBlock;
import com.ldtteam.domumornamentum.datagen.MateriallyTexturedModelBuilder;
import com.ldtteam.domumornamentum.datagen.utils.ModelBuilderUtils;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class TimberFramesBlockStateProvider
extends BlockStateProvider {
    public TimberFramesBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "domum_ornamentum", exFileHelper);
    }

    protected void registerStatesAndModels() {
        ModBlocks.getInstance().getTimberFrames().forEach(this::registerStatesAndModelsFor);
    }

    private void registerStatesAndModelsFor(TimberFrameBlock timberFrameBlock) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(timberFrameBlock);
        ModelBuilder blockModel = ((MateriallyTexturedModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/timber_frame/" + Objects.requireNonNull(timberFrameBlock.getRegistryName()).getPath(), this.modLoc("block/timber_frame/" + Objects.requireNonNull(timberFrameBlock.getRegistryName()).getPath() + "_spec").toString())).customLoader(MateriallyTexturedModelBuilder::new)).end();
        TimberFrameBlock.FACING.getPossibleValues().forEach(arg_0 -> this.lambda$registerStatesAndModelsFor$0(builder, (ModelFile)blockModel, timberFrameBlock, arg_0));
        ModelBuilderUtils.applyDefaultItemTransforms((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(timberFrameBlock.getRegistryName().getPath())).parent((ModelFile)blockModel));
    }

    private int getXFromDirection(Direction direction) {
        return switch (direction) {
            case Direction.UP -> 0;
            case Direction.DOWN -> 180;
            default -> 90;
        };
    }

    private int getYFromDirection(Direction direction) {
        return switch (direction) {
            default -> 0;
            case Direction.EAST -> 90;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
        };
    }

    @NotNull
    public String getName() {
        return "Timber Frames BlockStates Provider";
    }

    private /* synthetic */ void lambda$registerStatesAndModelsFor$0(MultiPartBlockStateBuilder builder, ModelFile blockModel, TimberFrameBlock timberFrameBlock, Direction direction) {
        ConfiguredModel.Builder partBuilder = builder.part().modelFile(blockModel);
        if (timberFrameBlock.getTimberFrameType().isRotatable()) {
            partBuilder.rotationX(this.getXFromDirection(direction));
            partBuilder.rotationY(this.getYFromDirection(direction));
        }
        ((MultiPartBlockStateBuilder.PartBuilder)partBuilder.addModel()).condition((Property)TimberFrameBlock.FACING, (Comparable[])new Direction[]{direction});
    }
}

