/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.extra;

import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.ExtraBlock;
import com.ldtteam.domumornamentum.block.types.ExtraBlockType;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ExtraRecipeProvider
extends RecipeProvider {
    public ExtraRecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    protected void buildRecipes(@NotNull RecipeOutput writer) {
        ModBlocks.getInstance().getExtraTopBlocks().forEach(extraBlock -> this.extraBlockRecipe(writer, (ExtraBlock)extraBlock));
    }

    private void extraBlockRecipe(RecipeOutput writer, ExtraBlock extraBlock) {
        ExtraBlockType type = extraBlock.getType();
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)extraBlock, (int)4);
        builder.pattern("X X");
        builder.pattern(" Z ");
        builder.pattern("X X");
        builder.define(Character.valueOf('X'), (ItemLike)type.getMaterial());
        if (type.getColor() == null) {
            builder.define(Character.valueOf('Z'), (ItemLike)type.getMaterial());
        } else {
            builder.define(Character.valueOf('Z'), (ItemLike)DyeItem.byColor((DyeColor)type.getColor()));
        }
        builder.unlockedBy("has_material", ExtraRecipeProvider.has((ItemLike)type.getMaterial()));
        if (type.getColor() != null) {
            builder.unlockedBy("has_dye", ExtraRecipeProvider.has((ItemLike)DyeItem.byColor((DyeColor)type.getColor())));
        }
        builder.save(writer);
    }

    @NotNull
    public String getName() {
        return "Extra Blocks Recipe Provider";
    }
}

