/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.bricks;

import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.BrickBlock;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class BrickRecipeProvider
extends RecipeProvider {
    public BrickRecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    protected void buildRecipes(@NotNull RecipeOutput recipeWriter) {
        ModBlocks.getInstance().getBricks().forEach(brickBlock -> this.brickBlockRecipe(recipeWriter, (BrickBlock)brickBlock));
    }

    private void brickBlockRecipe(RecipeOutput recipeWriter, BrickBlock brickBlock) {
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)brickBlock, (int)4);
        builder.requires((ItemLike)brickBlock.getType().getIngredient(), 2);
        builder.requires((ItemLike)brickBlock.getType().getIngredient2(), 2);
        builder.unlockedBy("has_item1_" + Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)brickBlock.asItem().asItem())).toString().replace(":", "_"), BrickRecipeProvider.has((ItemLike)brickBlock.getType().getIngredient()));
        builder.unlockedBy("has_item2_" + Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)brickBlock.asItem().asItem())).toString().replace(":", "_"), BrickRecipeProvider.has((ItemLike)brickBlock.getType().getIngredient()));
        builder.save(recipeWriter);
    }

    @NotNull
    public String getName() {
        return "Brick Blocks Recipe Provider";
    }
}

