/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.client.event.handlers;

import com.ldtteam.domumornamentum.client.render.ModelGhostRenderer;
import com.ldtteam.domumornamentum.util.ItemStackUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@EventBusSubscriber(modid="domum_ornamentum", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class MateriallyTexturedBlockPreviewRenderHandler {
    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_LEVEL) {
            PoseStack poseStack = event.getPoseStack();
            MateriallyTexturedBlockPreviewRenderHandler.renderMateriallyTexturedBlockPreview(poseStack);
        }
    }

    public static void renderMateriallyTexturedBlockPreview(PoseStack poseStack) {
        BlockHitResult blockRayTraceResult;
        HitResult rayTraceResult = Minecraft.getInstance().hitResult;
        if (!(rayTraceResult instanceof BlockHitResult) || (blockRayTraceResult = (BlockHitResult)rayTraceResult).getType() == HitResult.Type.MISS) {
            return;
        }
        LocalPlayer playerEntity = Minecraft.getInstance().player;
        if (playerEntity == null || playerEntity.isSpectator()) {
            return;
        }
        ItemStack heldStack = ItemStackUtils.getMateriallyTexturedItemStackFromPlayer((Player)playerEntity);
        if (heldStack.isEmpty()) {
            return;
        }
        Vec3 targetedRenderPos = Vec3.atLowerCornerOf((Vec3i)blockRayTraceResult.getBlockPos().offset(blockRayTraceResult.getDirection().getNormal()));
        MateriallyTexturedBlockPreviewRenderHandler.renderGhost(poseStack, heldStack, targetedRenderPos, blockRayTraceResult, Minecraft.getInstance().level);
    }

    private static void renderGhost(PoseStack poseStack, ItemStack heldStack, Vec3 targetedRenderPos, BlockHitResult blockRayTraceResult, ClientLevel level) {
        ModelGhostRenderer.getInstance().renderGhost(poseStack, heldStack, targetedRenderPos, blockRayTraceResult, level, false);
    }
}

