/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block;

import com.ldtteam.domumornamentum.block.ArchitectsCutterBlock;
import com.ldtteam.domumornamentum.block.ICachedItemGroupBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.IModBlocks;
import com.ldtteam.domumornamentum.block.decorative.AllBrickBlock;
import com.ldtteam.domumornamentum.block.decorative.AllBrickStairBlock;
import com.ldtteam.domumornamentum.block.decorative.BarrelBlock;
import com.ldtteam.domumornamentum.block.decorative.BrickBlock;
import com.ldtteam.domumornamentum.block.decorative.ExtraBlock;
import com.ldtteam.domumornamentum.block.decorative.FancyDoorBlock;
import com.ldtteam.domumornamentum.block.decorative.FancyTrapdoorBlock;
import com.ldtteam.domumornamentum.block.decorative.FloatingCarpetBlock;
import com.ldtteam.domumornamentum.block.decorative.FramedLightBlock;
import com.ldtteam.domumornamentum.block.decorative.PanelBlock;
import com.ldtteam.domumornamentum.block.decorative.PaperWallBlock;
import com.ldtteam.domumornamentum.block.decorative.PillarBlock;
import com.ldtteam.domumornamentum.block.decorative.PostBlock;
import com.ldtteam.domumornamentum.block.decorative.ShingleBlock;
import com.ldtteam.domumornamentum.block.decorative.ShingleSlabBlock;
import com.ldtteam.domumornamentum.block.decorative.TimberFrameBlock;
import com.ldtteam.domumornamentum.block.types.BrickType;
import com.ldtteam.domumornamentum.block.types.ExtraBlockType;
import com.ldtteam.domumornamentum.block.types.FramedLightType;
import com.ldtteam.domumornamentum.block.types.TimberFrameType;
import com.ldtteam.domumornamentum.block.vanilla.DoorBlock;
import com.ldtteam.domumornamentum.block.vanilla.FenceBlock;
import com.ldtteam.domumornamentum.block.vanilla.FenceGateBlock;
import com.ldtteam.domumornamentum.block.vanilla.SlabBlock;
import com.ldtteam.domumornamentum.block.vanilla.StairBlock;
import com.ldtteam.domumornamentum.block.vanilla.TrapdoorBlock;
import com.ldtteam.domumornamentum.block.vanilla.WallBlock;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.item.decoration.AllBrickBlockItem;
import com.ldtteam.domumornamentum.item.decoration.AllBrickStairBlockItem;
import com.ldtteam.domumornamentum.item.decoration.ExtraBlockItem;
import com.ldtteam.domumornamentum.item.decoration.FancyDoorBlockItem;
import com.ldtteam.domumornamentum.item.decoration.FancyTrapdoorBlockItem;
import com.ldtteam.domumornamentum.item.decoration.FramedLightBlockItem;
import com.ldtteam.domumornamentum.item.decoration.PanelBlockItem;
import com.ldtteam.domumornamentum.item.decoration.PaperwallBlockItem;
import com.ldtteam.domumornamentum.item.decoration.PillarBlockItem;
import com.ldtteam.domumornamentum.item.decoration.PostBlockItem;
import com.ldtteam.domumornamentum.item.decoration.ShingleBlockItem;
import com.ldtteam.domumornamentum.item.decoration.ShingleSlabBlockItem;
import com.ldtteam.domumornamentum.item.decoration.TimberFrameBlockItem;
import com.ldtteam.domumornamentum.item.interfaces.IDoItem;
import com.ldtteam.domumornamentum.item.vanilla.DoorBlockItem;
import com.ldtteam.domumornamentum.item.vanilla.FenceBlockItem;
import com.ldtteam.domumornamentum.item.vanilla.FenceGateBlockItem;
import com.ldtteam.domumornamentum.item.vanilla.SlabBlockItem;
import com.ldtteam.domumornamentum.item.vanilla.StairsBlockItem;
import com.ldtteam.domumornamentum.item.vanilla.TrapdoorBlockItem;
import com.ldtteam.domumornamentum.item.vanilla.WallBlockItem;
import com.ldtteam.domumornamentum.shingles.ShingleHeightType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public final class ModBlocks
implements IModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"domum_ornamentum");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"domum_ornamentum");
    private static final List<Supplier<TimberFrameBlock>> TIMBER_FRAMES = new ArrayList<Supplier<TimberFrameBlock>>();
    private static final List<Supplier<FramedLightBlock>> FRAMED_LIGHT = new ArrayList<Supplier<FramedLightBlock>>();
    private static final List<Supplier<FloatingCarpetBlock>> FLOATING_CARPETS = new ArrayList<Supplier<FloatingCarpetBlock>>();
    private static final List<Supplier<ExtraBlock>> EXTRA_TOP_BLOCKS = new ArrayList<Supplier<ExtraBlock>>();
    private static final List<Supplier<BrickBlock>> BRICK = new ArrayList<Supplier<BrickBlock>>();
    private static final List<Supplier<PillarBlock>> PILLARS = new ArrayList<Supplier<PillarBlock>>();
    private static final List<Supplier<AllBrickBlock>> ALL_BRICK = new ArrayList<Supplier<AllBrickBlock>>();
    private static final List<Supplier<AllBrickStairBlock>> ALL_BRICK_STAIR = new ArrayList<Supplier<AllBrickStairBlock>>();
    private static final ModBlocks INSTANCE = new ModBlocks();
    private static final DeferredBlock<ArchitectsCutterBlock> ARCHITECTS_CUTTER = ModBlocks.registerSimpleBlockItem("architectscutter", ArchitectsCutterBlock::new);
    private static final DeferredBlock<ShingleBlock> SHINGLE;
    private static final DeferredBlock<ShingleBlock> SHINGLE_FLAT;
    private static final DeferredBlock<ShingleBlock> SHINGLE_FLAT_LOWER;
    private static final DeferredBlock<ShingleSlabBlock> SHINGLE_SLAB;
    private static final DeferredBlock<PaperWallBlock> PAPER_WALL;
    private static final DeferredBlock<BarrelBlock> STANDING_BARREL;
    private static final DeferredBlock<BarrelBlock> LAYING_BARREL;
    private static final DeferredBlock<FenceBlock> FENCE;
    private static final DeferredBlock<FenceGateBlock> FENCE_GATE;
    private static final DeferredBlock<SlabBlock> SLAB;
    private static final DeferredBlock<WallBlock> WALL;
    private static final DeferredBlock<StairBlock> STAIR;
    private static final DeferredBlock<TrapdoorBlock> TRAPDOOR;
    private static final DeferredBlock<DoorBlock> DOOR;
    private static final DeferredBlock<PostBlock> POST;
    private static final DeferredBlock<PanelBlock> PANEL;
    private static final DeferredBlock<FancyDoorBlock> FANCY_DOOR;
    private static final DeferredBlock<FancyTrapdoorBlock> FANCY_TRAPDOOR;
    public Map<ResourceLocation, List<ItemStack>> itemGroups = new TreeMap<ResourceLocation, List<ItemStack>>();

    private ModBlocks() {
    }

    public static ModBlocks getInstance() {
        return INSTANCE;
    }

    public static <B extends Block> DeferredBlock<B> registerSimpleBlockItem(String name, Supplier<B> block) {
        DeferredBlock registered = BLOCKS.register(name, block);
        ITEMS.registerSimpleBlockItem((Holder)registered);
        return registered;
    }

    public static <B extends Block> DeferredBlock<B> registerCustomBlockItem(String name, Supplier<B> block, Function<B, ? extends BlockItem> item) {
        DeferredBlock registered = BLOCKS.register(name, block);
        ITEMS.register(((ResourceKey)registered.unwrapKey().orElseThrow()).location().getPath(), key -> (BlockItem)item.apply((Block)registered.value()));
        return registered;
    }

    @Override
    public ArchitectsCutterBlock getArchitectsCutter() {
        return (ArchitectsCutterBlock)ARCHITECTS_CUTTER.get();
    }

    @Override
    public ShingleBlock getShingle(ShingleHeightType heightType) {
        return switch (heightType) {
            default -> throw new MatchException(null, null);
            case ShingleHeightType.DEFAULT -> (ShingleBlock)SHINGLE.get();
            case ShingleHeightType.FLAT -> (ShingleBlock)SHINGLE_FLAT.get();
            case ShingleHeightType.FLAT_LOWER -> (ShingleBlock)SHINGLE_FLAT_LOWER.get();
        };
    }

    public List<TimberFrameBlock> getTimberFrames() {
        return TIMBER_FRAMES.stream().map(Supplier::get).collect(Collectors.toList());
    }

    public List<FramedLightBlock> getFramedLights() {
        return FRAMED_LIGHT.stream().map(Supplier::get).collect(Collectors.toList());
    }

    public List<PillarBlock> getPillars() {
        return PILLARS.stream().map(Supplier::get).collect(Collectors.toList());
    }

    public ShingleSlabBlock getShingleSlab() {
        return (ShingleSlabBlock)SHINGLE_SLAB.get();
    }

    public PaperWallBlock getPaperWall() {
        return (PaperWallBlock)PAPER_WALL.get();
    }

    public List<ExtraBlock> getExtraTopBlocks() {
        return EXTRA_TOP_BLOCKS.stream().map(Supplier::get).toList();
    }

    public List<FloatingCarpetBlock> getFloatingCarpets() {
        return FLOATING_CARPETS.stream().map(Supplier::get).toList();
    }

    @Override
    public BarrelBlock getStandingBarrel() {
        return (BarrelBlock)STANDING_BARREL.get();
    }

    @Override
    public BarrelBlock getLayingBarrel() {
        return (BarrelBlock)LAYING_BARREL.get();
    }

    public FenceBlock getFence() {
        return (FenceBlock)FENCE.get();
    }

    public FenceGateBlock getFenceGate() {
        return (FenceGateBlock)FENCE_GATE.get();
    }

    public SlabBlock getSlab() {
        return (SlabBlock)SLAB.get();
    }

    public List<BrickBlock> getBricks() {
        return BRICK.stream().map(Supplier::get).toList();
    }

    public WallBlock getWall() {
        return (WallBlock)WALL.get();
    }

    public StairBlock getStair() {
        return (StairBlock)STAIR.get();
    }

    public TrapdoorBlock getTrapdoor() {
        return (TrapdoorBlock)TRAPDOOR.get();
    }

    public PanelBlock getPanel() {
        return (PanelBlock)PANEL.get();
    }

    public PostBlock getPost() {
        return (PostBlock)POST.get();
    }

    public DoorBlock getDoor() {
        return (DoorBlock)DOOR.get();
    }

    public FancyDoorBlock getFancyDoor() {
        return (FancyDoorBlock)FANCY_DOOR.get();
    }

    public FancyTrapdoorBlock getFancyTrapdoor() {
        return (FancyTrapdoorBlock)FANCY_TRAPDOOR.get();
    }

    public List<AllBrickBlock> getAllBrickBlocks() {
        return ALL_BRICK.stream().map(Supplier::get).toList();
    }

    public List<AllBrickStairBlock> getAllBrickStairBlocks() {
        return ALL_BRICK_STAIR.stream().map(Supplier::get).toList();
    }

    public Map<ResourceLocation, List<ItemStack>> getOrComputeItemGroups() {
        if (this.itemGroups.isEmpty()) {
            BuiltInRegistries.ITEM.forEach(item -> {
                if (item instanceof IDoItem) {
                    BlockItem blockitem;
                    Block patt0$temp;
                    List itemList = this.itemGroups.getOrDefault(((IDoItem)item).getGroup(), new ArrayList());
                    if (item instanceof BlockItem && (patt0$temp = (blockitem = (BlockItem)item).getBlock()) instanceof IMateriallyTexturedBlock) {
                        IMateriallyTexturedBlock texturedBlock = (IMateriallyTexturedBlock)patt0$temp;
                        Block patt1$temp = blockitem.getBlock();
                        if (patt1$temp instanceof ICachedItemGroupBlock) {
                            ICachedItemGroupBlock cachedItemGroupBlock = (ICachedItemGroupBlock)patt1$temp;
                            NonNullList stacks = NonNullList.create();
                            cachedItemGroupBlock.fillItemCategory((NonNullList<ItemStack>)stacks);
                            for (ItemStack stack : stacks) {
                                itemList.add(this.process(stack.copy(), texturedBlock));
                            }
                        } else {
                            itemList.add(this.process(new ItemStack((ItemLike)item), texturedBlock));
                        }
                    }
                    this.itemGroups.put(((IDoItem)item).getGroup(), itemList);
                }
            });
        }
        return this.itemGroups;
    }

    private ItemStack process(ItemStack stack, IMateriallyTexturedBlock block) {
        @NotNull ArrayList<IMateriallyTexturedBlockComponent> components = new ArrayList<IMateriallyTexturedBlockComponent>(block.getComponents());
        MaterialTextureData.Builder textureData = MaterialTextureData.builder();
        for (IMateriallyTexturedBlockComponent component : components) {
            textureData.setComponent(component.getId(), component.getDefault());
        }
        textureData.writeToItemStack(stack);
        return stack;
    }

    public static Block[] getMateriallyTexturableBlocks() {
        return (Block[])((Registry)BLOCKS.getRegistry().get()).stream().filter(IMateriallyTexturedBlock.class::isInstance).toArray(Block[]::new);
    }

    public static Item[] getMateriallyTexturableItems() {
        return (Item[])Arrays.stream(ModBlocks.getMateriallyTexturableBlocks()).map(block -> ((Registry)BLOCKS.getRegistry().get()).getKey(block)).map(name -> (Item)((Registry)ITEMS.getRegistry().get()).get(name)).toArray(Item[]::new);
    }

    private static /* synthetic */ BrickBlock lambda$static$15(BrickType type) {
        return new BrickBlock(type);
    }

    private static /* synthetic */ FloatingCarpetBlock lambda$static$14(DyeColor color) {
        return new FloatingCarpetBlock(color);
    }

    private static /* synthetic */ FramedLightBlock lambda$static$12(FramedLightType blockType) {
        return new FramedLightBlock(blockType);
    }

    private static /* synthetic */ ExtraBlock lambda$static$10(ExtraBlockType blockType) {
        return new ExtraBlock(blockType);
    }

    static {
        for (TimberFrameType timberFrameType : TimberFrameType.values()) {
            TIMBER_FRAMES.add((Supplier<TimberFrameBlock>)ModBlocks.registerCustomBlockItem(timberFrameType.getName(), () -> new TimberFrameBlock(timberFrameType), b -> new TimberFrameBlockItem((TimberFrameBlock)b, new Item.Properties())));
        }
        SHINGLE = ModBlocks.registerCustomBlockItem("shingle", ShingleBlock::new, b -> new ShingleBlockItem((ShingleBlock)b, new Item.Properties()));
        SHINGLE_FLAT = ModBlocks.registerCustomBlockItem("shingle_flat", ShingleBlock::new, b -> new ShingleBlockItem((ShingleBlock)b, new Item.Properties()));
        SHINGLE_FLAT_LOWER = ModBlocks.registerCustomBlockItem("shingle_flat_lower", ShingleBlock::new, b -> new ShingleBlockItem((ShingleBlock)b, new Item.Properties()));
        SHINGLE_SLAB = ModBlocks.registerCustomBlockItem("shingle_slab", ShingleSlabBlock::new, b -> new ShingleSlabBlockItem((ShingleSlabBlock)b, new Item.Properties()));
        PAPER_WALL = ModBlocks.registerCustomBlockItem("blockpaperwall", PaperWallBlock::new, b -> new PaperwallBlockItem((PaperWallBlock)b, new Item.Properties()));
        PILLARS.add((Supplier<PillarBlock>)ModBlocks.registerCustomBlockItem("blockpillar", PillarBlock::new, b -> new PillarBlockItem((PillarBlock)b, new Item.Properties())));
        PILLARS.add((Supplier<PillarBlock>)ModBlocks.registerCustomBlockItem("blockypillar", PillarBlock::new, b -> new PillarBlockItem((PillarBlock)b, new Item.Properties())));
        PILLARS.add((Supplier<PillarBlock>)ModBlocks.registerCustomBlockItem("squarepillar", PillarBlock::new, b -> new PillarBlockItem((PillarBlock)b, new Item.Properties())));
        for (Enum enum_ : ExtraBlockType.values()) {
            EXTRA_TOP_BLOCKS.add((Supplier<ExtraBlock>)ModBlocks.registerCustomBlockItem(((ExtraBlockType)enum_).getSerializedName(), () -> ModBlocks.lambda$static$10((ExtraBlockType)enum_), b -> new ExtraBlockItem((ExtraBlock)b, new Item.Properties())));
        }
        for (Enum enum_ : FramedLightType.values()) {
            FRAMED_LIGHT.add((Supplier<FramedLightBlock>)ModBlocks.registerCustomBlockItem(((FramedLightType)enum_).getName(), () -> ModBlocks.lambda$static$12((FramedLightType)enum_), b -> new FramedLightBlockItem((FramedLightBlock)b, new Item.Properties())));
        }
        for (Enum enum_ : DyeColor.values()) {
            FLOATING_CARPETS.add((Supplier<FloatingCarpetBlock>)ModBlocks.registerSimpleBlockItem(enum_.getName().toLowerCase(Locale.ROOT) + "_floating_carpet", () -> ModBlocks.lambda$static$14((DyeColor)enum_)));
        }
        for (Enum enum_ : BrickType.values()) {
            BRICK.add((Supplier<BrickBlock>)ModBlocks.registerSimpleBlockItem(((BrickType)enum_).getSerializedName(), () -> ModBlocks.lambda$static$15((BrickType)enum_)));
        }
        STANDING_BARREL = ModBlocks.registerSimpleBlockItem("blockbarreldeco_standing", BarrelBlock::new);
        LAYING_BARREL = ModBlocks.registerSimpleBlockItem("blockbarreldeco_onside", BarrelBlock::new);
        FENCE = ModBlocks.registerCustomBlockItem("vanilla_fence_compat", FenceBlock::new, b -> new FenceBlockItem((FenceBlock)b, new Item.Properties()));
        FENCE_GATE = ModBlocks.registerCustomBlockItem("vanilla_fence_gate_compat", FenceGateBlock::new, b -> new FenceGateBlockItem((FenceGateBlock)b, new Item.Properties()));
        SLAB = ModBlocks.registerCustomBlockItem("vanilla_slab_compat", SlabBlock::new, b -> new SlabBlockItem((SlabBlock)b, new Item.Properties()));
        WALL = ModBlocks.registerCustomBlockItem("vanilla_wall_compat", WallBlock::new, b -> new WallBlockItem((WallBlock)b, new Item.Properties()));
        STAIR = ModBlocks.registerCustomBlockItem("vanilla_stairs_compat", StairBlock::new, b -> new StairsBlockItem((StairBlock)b, new Item.Properties()));
        TRAPDOOR = ModBlocks.registerCustomBlockItem("vanilla_trapdoors_compat", TrapdoorBlock::new, b -> new TrapdoorBlockItem((TrapdoorBlock)b, new Item.Properties()));
        DOOR = ModBlocks.registerCustomBlockItem("vanilla_doors_compat", DoorBlock::new, b -> new DoorBlockItem((DoorBlock)b, new Item.Properties()));
        PANEL = ModBlocks.registerCustomBlockItem("panel", PanelBlock::new, b -> new PanelBlockItem((PanelBlock)b, new Item.Properties()));
        ALL_BRICK.add((Supplier<AllBrickBlock>)ModBlocks.registerCustomBlockItem("light_brick", AllBrickBlock::new, b -> new AllBrickBlockItem((AllBrickBlock)b, new Item.Properties())));
        ALL_BRICK.add((Supplier<AllBrickBlock>)ModBlocks.registerCustomBlockItem("dark_brick", AllBrickBlock::new, b -> new AllBrickBlockItem((AllBrickBlock)b, new Item.Properties())));
        ALL_BRICK_STAIR.add((Supplier<AllBrickStairBlock>)ModBlocks.registerCustomBlockItem("light_brick_stair", AllBrickStairBlock::new, b -> new AllBrickStairBlockItem((AllBrickStairBlock)b, new Item.Properties())));
        ALL_BRICK_STAIR.add((Supplier<AllBrickStairBlock>)ModBlocks.registerCustomBlockItem("dark_brick_stair", AllBrickStairBlock::new, b -> new AllBrickStairBlockItem((AllBrickStairBlock)b, new Item.Properties())));
        POST = ModBlocks.registerCustomBlockItem("post", PostBlock::new, b -> new PostBlockItem((PostBlock)b, new Item.Properties()));
        FANCY_DOOR = ModBlocks.registerCustomBlockItem("fancy_door", FancyDoorBlock::new, b -> new FancyDoorBlockItem((FancyDoorBlock)b, new Item.Properties()));
        FANCY_TRAPDOOR = ModBlocks.registerCustomBlockItem("fancy_trapdoors", FancyTrapdoorBlock::new, b -> new FancyTrapdoorBlockItem((FancyTrapdoorBlock)b, new Item.Properties()));
    }
}

