/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.deco_storage.recipe;

import com.yablon.deco_storage.recipe.MyRecipeSerializers;
import com.yablon.deco_storage.recipe.MyRecipeTypes;
import com.yablon.deco_storage.recipe.StorageExtractorInput;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class StorageExtractorRecipe
implements Recipe<StorageExtractorInput> {
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack firstOutput;
    private final ItemStack secondOutput;
    private final float bonusChance;

    public StorageExtractorRecipe(NonNullList<Ingredient> ingredients, ItemStack firstOutput, ItemStack secondOutput, float bonusChance) {
        this.ingredients = ingredients;
        this.firstOutput = firstOutput;
        this.secondOutput = secondOutput;
        this.bonusChance = bonusChance;
    }

    public boolean matches(StorageExtractorInput input, Level pLevel) {
        if (pLevel.isClientSide()) {
            return false;
        }
        return ((Ingredient)this.ingredients.get(0)).test(input.getInputItem());
    }

    public ItemStack assemble(StorageExtractorInput input, HolderLookup.Provider provider) {
        return this.firstOutput.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.firstOutput.copy();
    }

    public ItemStack getFirstOutput() {
        return this.firstOutput;
    }

    public ItemStack getSecondOutput() {
        return this.secondOutput;
    }

    public float getBonusChance() {
        return this.bonusChance;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public RecipeSerializer<?> getSerializer() {
        return MyRecipeSerializers.STORAGE_EXTRACTOR.get();
    }

    public RecipeType<?> getType() {
        return MyRecipeTypes.STORAGE_EXTRACTOR.get();
    }
}

