/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.deco_storage;

import com.mojang.logging.LogUtils;
import com.yablon.deco_storage.Config;
import com.yablon.deco_storage.ModCreativeTabs;
import com.yablon.deco_storage.block.ModBlocks;
import com.yablon.deco_storage.block.entities.ModBlockEntities;
import com.yablon.deco_storage.item.ModItems;
import com.yablon.deco_storage.recipe.MyRecipeSerializers;
import com.yablon.deco_storage.recipe.MyRecipeTypes;
import com.yablon.deco_storage.screen.ModMenuTypes;
import com.yablon.deco_storage.screen.StorageCrafterScreen;
import com.yablon.deco_storage.screen.StorageExtractorScreen;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="deco_storage")
public class DecorativeStorage {
    public static final String MOD_ID = "deco_storage";
    private static final Logger LOGGER = LogUtils.getLogger();

    public DecorativeStorage(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ModCreativeTabs.register(modEventBus);
        MyRecipeTypes.RECIPE_TYPES.register(modEventBus);
        MyRecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        if (Config.logDirtBlock) {
            LOGGER.info("DIRT BLOCK >> {}", (Object)BuiltInRegistries.BLOCK.getKey((Object)Blocks.DIRT));
        }
        LOGGER.info(Config.magicNumberIntroduction + Config.magicNumber);
        Config.items.forEach(item -> LOGGER.info("ITEM >> {}", (Object)item.toString()));
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
        RecipeManager recipeManager = event.getServer().getRecipeManager();
        List recipes = recipeManager.getAllRecipesFor(MyRecipeTypes.STORAGE_CRAFTER.get());
        List exRecipes = recipeManager.getAllRecipesFor(MyRecipeTypes.STORAGE_EXTRACTOR.get());
        for (RecipeHolder recipe : recipes) {
            System.out.println("Loaded Crafter recipe: " + String.valueOf(recipe));
        }
        for (RecipeHolder recipe : exRecipes) {
            System.out.println("Loaded Extractor recipe: " + String.valueOf(recipe));
        }
    }

    @EventBusSubscriber(modid="deco_storage", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.getInstance().getUser().getName());
        }

        @SubscribeEvent
        public static void clientLoad(RegisterMenuScreensEvent event) {
            event.register((MenuType)ModMenuTypes.STORAGE_CRAFTER_GUI.get(), StorageCrafterScreen::new);
            event.register((MenuType)ModMenuTypes.STORAGE_EXTRACTOR_GUI.get(), StorageExtractorScreen::new);
        }
    }
}

