/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.cubeswithoutborders.client.mixin;

import com.mojang.serialization.Codec;
import dev.kir.cubeswithoutborders.client.FullscreenManager;
import dev.kir.cubeswithoutborders.client.FullscreenMode;
import dev.kir.cubeswithoutborders.client.config.CubesWithoutBordersConfig;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.client.gui.screens.options.VideoSettingsScreen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={VideoSettingsScreen.class})
abstract class VideoOptionsScreenMixin
extends OptionsSubScreen {
    private VideoOptionsScreenMixin(Screen parent, Options gameOptions, Component title) {
        super(parent, gameOptions, title);
    }

    @Inject(method={"options(Lnet/minecraft/client/Options;)[Lnet/minecraft/client/OptionInstance;"}, at={@At(value="RETURN")})
    private static void patchFullscreenOption(Options gameOptions, CallbackInfoReturnable<OptionInstance<?>[]> cir) {
        CubesWithoutBordersConfig config = CubesWithoutBordersConfig.getInstance();
        if (config.getBorderlessFullscreenType() == config.getFullscreenType()) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        FullscreenManager window = (FullscreenManager)client.getWindow();
        OptionInstance[] options = (OptionInstance[])cir.getReturnValue();
        OptionInstance booleanFullscreenOption = gameOptions.fullscreen();
        OptionInstance enumFullscreenOption = new OptionInstance("options.fullscreen", OptionInstance.noTooltip(), (text, value) -> Component.translatable((String)value.getTranslationKey()), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(FullscreenMode.values()), Codec.INT.xmap(FullscreenMode::get, FullscreenMode::getId)), (Object)(window == null ? FullscreenMode.OFF : window.getFullscreenMode()), value -> {
            if (window == null || value == window.getFullscreenMode()) {
                return;
            }
            window.setFullscreenMode((FullscreenMode)((Object)value));
            booleanFullscreenOption.set((Object)(value != FullscreenMode.OFF ? 1 : 0));
        });
        for (int i = 0; i < options.length; ++i) {
            if (options[i] != booleanFullscreenOption) continue;
            options[i] = enumFullscreenOption;
            break;
        }
    }
}

