/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets.options;

import de.mrjulsen.crn.client.gui.widgets.options.OptionEntry;
import de.mrjulsen.crn.client.gui.widgets.options.OptionEntryHeader;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLScrollableWidgetContainer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLWidgetContainer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibWidget;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class DLOptionsList
extends DLScrollableWidgetContainer {
    private final DLAbstractScrollBar<?> scrollBar;
    private int contentHeight = 0;
    private final Screen parent;

    public DLOptionsList(Screen parent, int x, int y, int width, int height, DLAbstractScrollBar<?> scrollBar) {
        super(x, y, width, height);
        this.scrollBar = scrollBar;
        this.parent = parent;
        scrollBar.setAutoScrollerSize(true);
        scrollBar.setScreenSize(this.height());
        scrollBar.setMaxScroll(0);
        scrollBar.withOnValueChanged(sb -> this.setYScrollOffset(sb.getScrollValue()));
        scrollBar.setStepSize(10);
    }

    public void clearOptions() {
        this.clearWidgets();
        this.rearrangeContent();
    }

    public int getContentWidth() {
        return this.width() - 20;
    }

    public <T extends DLWidgetContainer> OptionEntry<T> addOption(Function<OptionEntry<T>, T> contentContainer, Component text, Component description, BiConsumer<OptionEntry<T>, OptionEntryHeader> onHeaderClick, Function<String, Boolean> onTitleEdited) {
        OptionEntry<T> entry = new OptionEntry<T>(this.parent, this, 0, this.y(), this.width() - 20, contentContainer, text, description, x -> this.rearrangeContent(), onHeaderClick, onTitleEdited);
        this.addRenderableWidget((T)entry);
        return entry;
    }

    public <T extends GuiEventListener & Renderable> T addRenderableWidget(T guiEventListener) {
        GuiEventListener t = super.addRenderableWidget(guiEventListener);
        if (t instanceof IDragonLibWidget) {
            IDragonLibWidget wgt = (IDragonLibWidget)t;
            wgt.set_x(this.x() + 10);
            wgt.set_width(Math.min(this.width() - 20, wgt.width()));
        } else if (t instanceof AbstractWidget) {
            AbstractWidget wgt = (AbstractWidget)t;
            wgt.setX(this.x() + 10);
            wgt.setWidth(Math.min(this.width() - 20, wgt.getWidth()));
        }
        this.rearrangeContent();
        return (T)t;
    }

    public void rearrangeContent() {
        this.contentHeight = 10;
        for (GuiEventListener listener : this.children()) {
            if (listener instanceof OptionEntry) {
                OptionEntry wgt = (OptionEntry)listener;
                wgt.set_y(this.y() + this.contentHeight);
                this.contentHeight += wgt.height() + (wgt.isExpanded() ? 6 : 3);
                continue;
            }
            if (listener instanceof IDragonLibWidget) {
                IDragonLibWidget wgt = (IDragonLibWidget)listener;
                wgt.set_y(this.y() + this.contentHeight);
                this.contentHeight += wgt.height() + 3;
                continue;
            }
            if (!(listener instanceof AbstractWidget)) continue;
            AbstractWidget wgt = (AbstractWidget)listener;
            wgt.setY(this.y() + this.contentHeight);
            this.contentHeight += wgt.getHeight() + 3;
        }
        this.contentHeight += 10;
        this.scrollBar.setMaxScroll(this.contentHeight);
        if (!this.scrollBar.canScroll()) {
            this.scrollBar.scrollTo(0);
        }
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
        GuiUtils.fillGradient((Graphics)graphics, (int)this.x(), (int)this.y(), (int)0, (int)this.width(), (int)10, (int)0x77000000, (int)0);
        GuiUtils.fillGradient((Graphics)graphics, (int)this.x(), (int)(this.y() + this.height() - 10), (int)0, (int)this.width(), (int)10, (int)0, (int)0x77000000);
        if (this.children().isEmpty()) {
            int n = this.x() + this.width() / 2;
            int n2 = this.y() + this.height() / 2;
            Objects.requireNonNull(this.font);
            GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)n, (int)(n2 - 9 / 2), (FormattedText)TextUtils.translate((String)"gui.createrailwaysnavigator.empty_list"), (int)-6381922, (EAlignment)EAlignment.CENTER, (boolean)false);
        }
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.HOVERED;
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
    }

    public boolean consumeScrolling(double mouseX, double mouseY) {
        return false;
    }
}

