/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.trains.schedule.ScheduleScreen;
import com.simibubi.create.content.trains.schedule.condition.TimedWaitCondition;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.CreateLang;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.api.client.Screens;
import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.NavigatorToast;
import de.mrjulsen.crn.client.gui.screen.AdvancedDisplaySettingsScreen;
import de.mrjulsen.crn.client.gui.screen.PrioritizedDestinationInstructionSettingsScreen;
import de.mrjulsen.crn.client.gui.screen.TrainDebugScreen;
import de.mrjulsen.crn.client.gui.screen.TrainSectionSettingsScreen;
import de.mrjulsen.crn.client.gui.screen.TrainSeparationSettingsScreen;
import de.mrjulsen.crn.client.gui.widgets.ResizableButton;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.components.NavigatorBackgroundComponent;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.schedule.condition.DynamicDelayCondition;
import de.mrjulsen.crn.data.schedule.condition.TrainSeparationCondition;
import de.mrjulsen.crn.data.schedule.instruction.PrioritizedDestinationInstruction;
import de.mrjulsen.crn.data.schedule.instruction.ResetTimingsInstruction;
import de.mrjulsen.crn.data.schedule.instruction.TravelSectionInstruction;
import de.mrjulsen.crn.mixin.ModularGuiLineBuilderAccessor;
import de.mrjulsen.crn.mixin.ScheduleScreenAccessor;
import de.mrjulsen.crn.network.packets.stc.ServerErrorPacket;
import de.mrjulsen.crn.registry.ModDataComponents;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.ber.RenderGraphics;
import de.mrjulsen.mcdragonlib.client.ber.StaticBlockEntityRenderer;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.util.BERUtils;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.createmod.catnip.data.Pair;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class ClientWrapper {
    public static final ModelResourceLocation NAVIGATOR_WORLD_MODEL = ModelResourceLocation.inventory((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"navigator_world"));
    private static CustomLanguage currentLanguage;
    private static Language currentClientLanguage;

    public static void showNavigatorGui() {
        Screens.showNavigatorScreen(null, false);
    }

    public static Level getClientLevel() {
        return Minecraft.getInstance().level;
    }

    public static void handleErrorMessagePacket(ServerErrorPacket packet, Supplier<NetworkManager.PacketContext> ctx) {
        Minecraft.getInstance().getToasts().addToast((Toast)new SystemToast(SystemToast.SystemToastId.PERIODIC_NOTIFICATION, Constants.TEXT_SERVER_ERROR, (Component)TextUtils.text((String)packet.message)));
    }

    public static void showAdvancedDisplaySettingsScreen(AdvancedDisplayBlockEntity blockEntity, AbstractContraptionEntity contraption) {
        DLScreen.setScreen((DLScreen)new AdvancedDisplaySettingsScreen(blockEntity, contraption));
    }

    public static void updateLanguage(CustomLanguage lang, boolean force) {
        LanguageInfo info;
        if (currentLanguage == lang && !force) {
            return;
        }
        LanguageInfo languageInfo = info = lang == CustomLanguage.DEFAULT ? null : Minecraft.getInstance().getLanguageManager().getLanguage(lang.getCode());
        if (info == null) {
            info = Minecraft.getInstance().getLanguageManager().getLanguage(Minecraft.getInstance().getLanguageManager().getSelected());
        }
        currentLanguage = lang;
        if (lang == CustomLanguage.DEFAULT || info == null) {
            currentClientLanguage = Language.getInstance();
            CreateRailwaysNavigator.LOGGER.info("Updated custom language to: (Default)");
        } else {
            currentClientLanguage = ClientLanguage.loadFrom((ResourceManager)Minecraft.getInstance().getResourceManager(), List.of(lang == CustomLanguage.DEFAULT ? Minecraft.getInstance().getLanguageManager().getSelected() : lang.getCode()), (boolean)false);
            CreateRailwaysNavigator.LOGGER.info("Updated custom language to: " + (info == null ? null : info.name()));
        }
    }

    public static Language getCurrentClientLanguage() {
        return currentClientLanguage == null ? Language.getInstance() : currentClientLanguage;
    }

    public static void sendCRNNotification(Component title, Component description) {
        if (((Boolean)ModClientConfig.ROUTE_NOTIFICATIONS.get()).booleanValue()) {
            Minecraft.getInstance().getToasts().addToast((Toast)NavigatorToast.multiline(title, description));
        }
    }

    public static int renderMultilineLabelSafe(Graphics graphics, int x, int y, Font font, Component text, int maxWidth, int color) {
        MultiLineLabel label = MultiLineLabel.create((Font)font, (Component)text, (int)maxWidth);
        GuiGraphics guiGraphics = graphics.graphics();
        Objects.requireNonNull(font);
        label.renderLeftAlignedNoShadow(guiGraphics, x, y, 9, color);
        Objects.requireNonNull(font);
        return 9 * label.getLineCount();
    }

    public static int getTextBlockHeight(Font font, Component text, int maxWidth) {
        int lines = font.split((FormattedText)text, maxWidth).size();
        Objects.requireNonNull(font);
        return lines * 9;
    }

    public static void showTrainDebugScreen() {
        RenderSystem.recordRenderCall(() -> DLScreen.setScreen((DLScreen)new TrainDebugScreen(null)));
    }

    public static void initPrioritizedDestinationInstruction(PrioritizedDestinationInstruction instruction, ModularGuiLineBuilder builder) {
        ModularGuiLineBuilderAccessor accessor = (ModularGuiLineBuilderAccessor)builder;
        ResizableButton btn = new ResizableButton(accessor.crn$getX(), accessor.crn$getY() - 4, 121, 16, (Component)TextUtils.translate((String)"createrailwaysnavigator.schedule.instruction.configure"), b -> {
            Screen patt0$temp = Minecraft.getInstance().screen;
            if (patt0$temp instanceof ScheduleScreen) {
                ScheduleScreen scheduleScreen = (ScheduleScreen)patt0$temp;
                ((ScheduleScreenAccessor)scheduleScreen).crn$getOnEditorClose().accept(true);
                builder.customArea(0, 0).speechBubble();
                Minecraft.getInstance().setScreen((Screen)new PrioritizedDestinationInstructionSettingsScreen((Screen)scheduleScreen, instruction, instruction.getData()));
            }
        }){

            @Override
            public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Graphics graphics = new Graphics(guiGraphics, guiGraphics.pose());
                DynamicGuiRenderer.renderArea((Graphics)graphics, (int)this.getX(), (int)this.getY(), (int)this.width, (int)this.height, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.GRAY, (DynamicGuiRenderer.ButtonState)(this.isActive() ? (this.isFocused() || this.isMouseOver(mouseX, mouseY) ? DynamicGuiRenderer.ButtonState.SELECTED : DynamicGuiRenderer.ButtonState.BUTTON) : DynamicGuiRenderer.ButtonState.DISABLED));
                int j = this.isActive() ? -1 : -6381922;
                GuiUtils.drawString((Graphics)graphics, (Font)Minecraft.getInstance().font, (int)(this.getX() + this.width / 2), (int)(this.getY() + (this.height - 8) / 2), (FormattedText)this.getMessage(), (int)j, (EAlignment)EAlignment.CENTER, (boolean)true);
            }
        };
        accessor.crn$getTarget().add(Pair.of((Object)((Object)btn), (Object)"config_btn"));
    }

    public static void initScheduleSectionInstruction(TravelSectionInstruction instruction, ModularGuiLineBuilder builder) {
        ModularGuiLineBuilderAccessor accessor = (ModularGuiLineBuilderAccessor)builder;
        ResizableButton btn = new ResizableButton(accessor.crn$getX(), accessor.crn$getY() - 4, 121, 16, (Component)TextUtils.translate((String)"createrailwaysnavigator.schedule.instruction.configure"), b -> {
            Screen patt0$temp = Minecraft.getInstance().screen;
            if (patt0$temp instanceof ScheduleScreen) {
                ScheduleScreen scheduleScreen = (ScheduleScreen)patt0$temp;
                ((ScheduleScreenAccessor)scheduleScreen).crn$getOnEditorClose().accept(true);
                builder.customArea(0, 0).speechBubble();
                Minecraft.getInstance().setScreen((Screen)new TrainSectionSettingsScreen((Screen)scheduleScreen, instruction.getData()));
            }
        }){

            @Override
            public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Graphics graphics = new Graphics(guiGraphics, guiGraphics.pose());
                DynamicGuiRenderer.renderArea((Graphics)graphics, (int)this.getX(), (int)this.getY(), (int)this.width, (int)this.height, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.GRAY, (DynamicGuiRenderer.ButtonState)(this.isActive() ? (this.isFocused() || this.isMouseOver(mouseX, mouseY) ? DynamicGuiRenderer.ButtonState.SELECTED : DynamicGuiRenderer.ButtonState.BUTTON) : DynamicGuiRenderer.ButtonState.DISABLED));
                int j = this.isActive() ? -1 : -6381922;
                GuiUtils.drawString((Graphics)graphics, (Font)Minecraft.getInstance().font, (int)(this.getX() + this.width / 2), (int)(this.getY() + (this.height - 8) / 2), (FormattedText)this.getMessage(), (int)j, (EAlignment)EAlignment.CENTER, (boolean)true);
            }
        };
        accessor.crn$getTarget().add(Pair.of((Object)((Object)btn), (Object)"config_btn"));
    }

    public static void initResetTimingsInstruction(ResetTimingsInstruction instruction, ModularGuiLineBuilder builder) {
        ModularGuiLineBuilderAccessor accessor = (ModularGuiLineBuilderAccessor)builder;
        ResizableButton btn = new ResizableButton(accessor.crn$getX(), accessor.crn$getY() - 4, 16, 16, (Component)TextUtils.empty(), b -> Util.getPlatform().openUri("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Scheduled-Time-and-Real-Time")){

            @Override
            public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Graphics graphics = new Graphics(guiGraphics, guiGraphics.pose());
                DynamicGuiRenderer.renderArea((Graphics)graphics, (int)this.getX(), (int)this.getY(), (int)this.width, (int)this.height, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.GRAY, (DynamicGuiRenderer.ButtonState)(this.isActive() ? (this.isFocused() || this.isMouseOver(mouseX, mouseY) ? DynamicGuiRenderer.ButtonState.SELECTED : DynamicGuiRenderer.ButtonState.BUTTON) : DynamicGuiRenderer.ButtonState.DISABLED));
                ModGuiIcons.HELP.render(graphics, this.getX(), this.getY());
            }
        };
        accessor.crn$getTarget().add(Pair.of((Object)((Object)btn), (Object)"help_btn"));
    }

    public static void initDynamicDelayCondition(DynamicDelayCondition condition, ModularGuiLineBuilder builder) {
        builder.addScrollInput(0, 26, (i, l) -> {
            i.titled(TextUtils.translate((String)("createrailwaysnavigator.schedule.condition." + condition.getId().getPath() + ".min_duration"))).withShiftStep(15).withRange(0, 121);
            i.lockedTooltipX = -15;
            i.lockedTooltipY = 35;
        }, "Min");
        builder.addScrollInput(26, 26, (i, l) -> {
            i.titled(CreateLang.translateDirect((String)"generic.duration", (Object[])new Object[0])).withShiftStep(15).withRange(0, 121);
            i.lockedTooltipX = -15;
            i.lockedTooltipY = 35;
        }, "Value");
        builder.addSelectionScrollInput(52, 58, (i, l) -> i.forOptions(TimedWaitCondition.TimeUnit.translatedOptions()).titled(CreateLang.translateDirect((String)"generic.timeUnit", (Object[])new Object[0])), "TimeUnit");
        ModularGuiLineBuilderAccessor accessor = (ModularGuiLineBuilderAccessor)builder;
        ResizableButton btn = new ResizableButton(accessor.crn$getX() + 110, accessor.crn$getY() - 4, 16, 16, (Component)TextUtils.empty(), b -> Util.getPlatform().openUri("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Dynamic-Delays")){

            @Override
            public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Graphics graphics = new Graphics(guiGraphics, guiGraphics.pose());
                DynamicGuiRenderer.renderArea((Graphics)graphics, (int)this.getX(), (int)this.getY(), (int)this.width, (int)this.height, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.GRAY, (DynamicGuiRenderer.ButtonState)(this.isActive() ? (this.isFocused() || this.isMouseOver(mouseX, mouseY) ? DynamicGuiRenderer.ButtonState.SELECTED : DynamicGuiRenderer.ButtonState.BUTTON) : DynamicGuiRenderer.ButtonState.DISABLED));
                ModGuiIcons.HELP.render(graphics, this.getX(), this.getY());
            }
        };
        accessor.crn$getTarget().add(Pair.of((Object)((Object)btn), (Object)"help_btn"));
    }

    public static void initTimingAdjustmentGui(TrainSeparationCondition condition, ModularGuiLineBuilder builder) {
        ModularGuiLineBuilderAccessor accessor = (ModularGuiLineBuilderAccessor)builder;
        ResizableButton btn = new ResizableButton(accessor.crn$getX(), accessor.crn$getY() - 4, 121, 16, (Component)TextUtils.translate((String)"createrailwaysnavigator.schedule.instruction.configure"), b -> {
            Screen patt0$temp = Minecraft.getInstance().screen;
            if (patt0$temp instanceof ScheduleScreen) {
                ScheduleScreen scheduleScreen = (ScheduleScreen)patt0$temp;
                ((ScheduleScreenAccessor)scheduleScreen).crn$getOnEditorClose().accept(true);
                builder.customArea(0, 0).speechBubble();
                Minecraft.getInstance().setScreen((Screen)new TrainSeparationSettingsScreen((Screen)scheduleScreen, condition.getData()));
            }
        }){

            @Override
            public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Graphics graphics = new Graphics(guiGraphics, guiGraphics.pose());
                DynamicGuiRenderer.renderArea((Graphics)graphics, (int)this.getX(), (int)this.getY(), (int)this.width, (int)this.height, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.GRAY, (DynamicGuiRenderer.ButtonState)(this.isActive() ? (this.isFocused() || this.isMouseOver(mouseX, mouseY) ? DynamicGuiRenderer.ButtonState.SELECTED : DynamicGuiRenderer.ButtonState.BUTTON) : DynamicGuiRenderer.ButtonState.DISABLED));
                int j = this.isActive() ? -1 : -6381922;
                GuiUtils.drawString((Graphics)graphics, (Font)Minecraft.getInstance().font, (int)(this.getX() + this.width / 2), (int)(this.getY() + (this.height - 8) / 2), (FormattedText)this.getMessage(), (int)j, (EAlignment)EAlignment.CENTER, (boolean)true);
            }
        };
        accessor.crn$getTarget().add(Pair.of((Object)((Object)btn), (Object)"config_btn"));
    }

    public static void renderNavigatorItem(RenderGraphics graphics, ItemStack itemStack, ItemDisplayContext context, boolean leftHand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel model) {
        if (context != ItemDisplayContext.FIRST_PERSON_LEFT_HAND && context != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND && context != ItemDisplayContext.FIXED) {
            return;
        }
        int backgroundId = 0;
        if (itemStack.has(ModDataComponents.NAVIGATOR_BACKGROUND_COMPONENT)) {
            backgroundId = ((NavigatorBackgroundComponent)itemStack.get(ModDataComponents.NAVIGATOR_BACKGROUND_COMPONENT)).backgroundId();
        }
        Font font = Minecraft.getInstance().font;
        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        poseStack.translate(4.0f, 2.0f, -1.26f);
        BERUtils.renderTexture((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)String.format("textures/item/navigator_backgrounds/%s.png", backgroundId)), (RenderGraphics)graphics, (boolean)false, (float)0.0f, (float)0.0f, (float)0.0f, (float)8.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.6666667f, (float)1.0f, (Direction)Direction.UP, (int)-1, (int)0xF000F0);
        poseStack.translate(0.0f, 0.0f, -0.01f);
        poseStack.pushPose();
        poseStack.translate(4.0f, 0.8f, 0.0f);
        poseStack.scale(0.075f, 0.075f, 0.075f);
        BERUtils.drawString((RenderGraphics)graphics, (Font)font, (float)0.0f, (float)0.0f, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.journey_info.date", (Object[])new Object[]{(DragonLib.getCurrentWorldTime() + DragonLib.daytimeShift()) / DragonLib.ticksPerDay()}), (int)-1, (EAlignment)EAlignment.CENTER, (boolean)false, (int)0xF000F0);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(4.0f, 2.0f, 0.0f);
        poseStack.scale(0.2f, 0.2f, 0.2f);
        BERUtils.drawString((RenderGraphics)graphics, (Font)font, (float)0.0f, (float)0.0f, (String)TimeUtils.formatTime((long)DragonLib.getCurrentWorldTime(), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get())), (int)-1, (EAlignment)EAlignment.CENTER, (boolean)false, (int)0xF000F0);
        poseStack.popPose();
    }

    public static Owner getMe() {
        return new Owner((Player)Minecraft.getInstance().player);
    }

    public static Player getClientPlayer() {
        return Minecraft.getInstance().player;
    }

    public static StaticBlockEntityRenderer<AdvancedDisplayBlockEntity> createAdvancedDisplayBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        return new StaticBlockEntityRenderer<AdvancedDisplayBlockEntity>(context){

            public boolean shouldRenderOffScreen(AdvancedDisplayBlockEntity blockEntity) {
                return blockEntity.isController();
            }

            public AABB getRenderBoundingBox(AdvancedDisplayBlockEntity blockEntity) {
                return blockEntity.getRenderBoundingBox();
            }
        };
    }
}

