/*
 * Decompiled with CFR 0.152.
 */
package com.forsteri.createendertransmission.blocks.itemTransmitter;

import com.forsteri.createendertransmission.blocks.itemTransmitter.ItemTransmitterBlockEntity;
import com.forsteri.createendertransmission.entry.TransmissionBlockEntities;
import com.forsteri.createendertransmission.entry.TransmissionBlocks;
import com.forsteri.createendertransmission.transmitUtil.TransmitterScreen;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.gui.ScreenOpener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLLoader;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class ItemTransmitterBlock
extends Block
implements IBE<ItemTransmitterBlockEntity>,
IWrenchable {
    public ItemTransmitterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public Class<ItemTransmitterBlockEntity> getBlockEntityClass() {
        return ItemTransmitterBlockEntity.class;
    }

    public BlockEntityType<? extends ItemTransmitterBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TransmissionBlockEntities.ITEM_TRANSMITTER_TILE_ENTITY.get();
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (AllItems.WRENCH.isIn(stack)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (FMLLoader.getDist() == Dist.CLIENT) {
            this.withBlockEntityDo((BlockGetter)level, pos, te -> this.displayScreen((ItemTransmitterBlockEntity)te, player));
        }
        return ItemInteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void displayScreen(ItemTransmitterBlockEntity te, Player player) {
        if (player instanceof LocalPlayer) {
            ScreenOpener.open((Screen)new TransmitterScreen(te, TransmissionBlocks.ITEM_TRANSMITTER_BLOCK.asStack()));
        }
    }

    @NotNull
    public VoxelShape getShape(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    }
}

