/*
 * Decompiled with CFR 0.152.
 */
package com.forsteri.createendertransmission.blocks.fluidTrasmitter;

import com.forsteri.createendertransmission.blocks.fluidTrasmitter.FluidTransmitterBlockEntity;
import com.forsteri.createendertransmission.entry.TransmissionBlockEntities;
import com.forsteri.createendertransmission.entry.TransmissionBlocks;
import com.forsteri.createendertransmission.transmitUtil.TransmitterScreen;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.gui.ScreenOpener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLLoader;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class FluidTransmitterBlock
extends Block
implements IBE<FluidTransmitterBlockEntity>,
IWrenchable {
    public FluidTransmitterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (AllItems.WRENCH.isIn(stack)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (FMLLoader.getDist() == Dist.CLIENT) {
            this.withBlockEntityDo((BlockGetter)level, pos, te -> this.displayScreen((FluidTransmitterBlockEntity)te, player));
        }
        return ItemInteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void displayScreen(FluidTransmitterBlockEntity te, Player player) {
        if (player instanceof LocalPlayer) {
            ScreenOpener.open((Screen)new TransmitterScreen(te, TransmissionBlocks.FLUID_TRANSMITTER_BLOCK.asStack()));
        }
    }

    public Class<FluidTransmitterBlockEntity> getBlockEntityClass() {
        return FluidTransmitterBlockEntity.class;
    }

    public BlockEntityType<? extends FluidTransmitterBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TransmissionBlockEntities.FLUID_TRANSMITTER_TILE_ENTITY.get();
    }
}

