/*
 * Decompiled with CFR 0.152.
 */
package com.forsteri.createappliedkinetics.content.meProxy;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.me.storage.NetworkStorage;
import com.forsteri.createappliedkinetics.content.meProxy.MEProxyBlockEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.EmptyFluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class MEProxyInventoryHandler
implements IItemHandler,
IFluidHandler {
    MEProxyBlockEntity blockEntity;

    public MEProxyInventoryHandler(MEProxyBlockEntity meProxyBlockEntity) {
        this.blockEntity = meProxyBlockEntity;
    }

    private Optional<NetworkStorage> getStorage() {
        IGrid grid = this.blockEntity.getMainNode().getGrid();
        if (grid == null) {
            return Optional.empty();
        }
        return Optional.of((NetworkStorage)grid.getStorageService().getInventory());
    }

    List<AEFluidKey> getFluidKeys() {
        return this.getStorage().map(storage -> storage.getAvailableStacks().keySet().stream().filter(aeKey -> aeKey instanceof AEFluidKey).map(aeKey -> (AEFluidKey)aeKey).toList()).orElse(List.of());
    }

    List<AEItemKey> getItemKeys() {
        return this.getStorage().map(storage -> storage.getAvailableStacks().keySet().stream().filter(aeKey -> aeKey instanceof AEItemKey).map(aeKey -> (AEItemKey)aeKey).toList()).orElse(List.of());
    }

    public int getTanks() {
        return this.getFluidKeys().size();
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        if (this.getStorage().isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (tank >= this.getFluidKeys().size()) {
            return FluidStack.EMPTY;
        }
        return this.getFluidKeys().get(tank).toStack((int)((NetworkStorage)this.getStorage().orElse(null)).extract((AEKey)this.getFluidKeys().get(tank), Integer.MAX_VALUE, Actionable.SIMULATE, IActionSource.empty()));
    }

    public int getTankCapacity(int tank) {
        return Integer.MAX_VALUE;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        if (this.getStorage().isEmpty()) {
            return false;
        }
        return ((NetworkStorage)this.getStorage().orElse(null)).insert((AEKey)AEFluidKey.of((FluidStack)stack), (long)stack.getAmount(), Actionable.SIMULATE, IActionSource.empty()) > 0L;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.getStorage().isEmpty()) {
            return 0;
        }
        return (int)((NetworkStorage)this.getStorage().orElse(null)).insert((AEKey)AEFluidKey.of((FluidStack)resource), (long)resource.getAmount(), action == IFluidHandler.FluidAction.EXECUTE ? Actionable.MODULATE : Actionable.SIMULATE, IActionSource.empty());
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.getStorage().isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack copied = resource.copy();
        if (copied.getFluid() instanceof EmptyFluid) {
            return FluidStack.EMPTY;
        }
        copied.setAmount((int)((NetworkStorage)this.getStorage().orElse(null)).extract((AEKey)AEFluidKey.of((FluidStack)resource), (long)resource.getAmount(), action == IFluidHandler.FluidAction.EXECUTE ? Actionable.MODULATE : Actionable.SIMULATE, IActionSource.empty()));
        return copied.getAmount() > 0 ? copied : FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack copied = this.getFluidInTank(0).copy();
        if (copied.getFluid() instanceof EmptyFluid) {
            return FluidStack.EMPTY;
        }
        if (copied.getAmount() > maxDrain) {
            copied.setAmount(maxDrain);
        }
        return this.drain(copied, action);
    }

    public int getSlots() {
        return this.getItemKeys().size() + 16;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (this.getStorage().isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (slot >= this.getItemKeys().size()) {
            return ItemStack.EMPTY;
        }
        return this.getItemKeys().get(slot).toStack((int)((NetworkStorage)this.getStorage().orElse(null)).extract((AEKey)this.getItemKeys().get(slot), Integer.MAX_VALUE, Actionable.SIMULATE, IActionSource.empty()));
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (this.getStorage().isEmpty()) {
            return stack;
        }
        ItemStack copied = stack.copy();
        copied.setCount(copied.getCount() - (int)((NetworkStorage)this.getStorage().orElse(null)).insert((AEKey)AEItemKey.of((ItemStack)stack), (long)stack.getCount(), simulate ? Actionable.SIMULATE : Actionable.MODULATE, IActionSource.empty()));
        return copied;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.getStorage().isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot).copy();
        AEItemKey key = AEItemKey.of((ItemStack)stackInSlot);
        if (key == null) {
            return ItemStack.EMPTY;
        }
        stackInSlot.setCount((int)((NetworkStorage)this.getStorage().orElse(null)).extract((AEKey)key, (long)amount, simulate ? Actionable.SIMULATE : Actionable.MODULATE, IActionSource.empty()));
        return stackInSlot;
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.insertItem(slot, stack, true).getCount() == 0;
    }
}

