/*
 * Decompiled with CFR 0.152.
 */
package com.weido.create_bb.visuals.standard;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.foundation.render.SpecialModels;
import com.weido.create_bb.data.rotation.BlocksBogiesBogieVisual;
import com.weido.create_bb.registry.BogiePartials;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

public class SingleAxleBogieVisual
extends BlocksBogiesBogieVisual {
    public SingleAxleBogieVisual(VisualizationContext ctx, float partialTick, boolean inContraption) {
    }

    @Override
    public void update(boolean forwards, float wheelAngle, PoseStack poseStack) {
    }

    public void hide() {
    }

    public void updateLight(int packedLight) {
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
    }

    public void delete() {
    }

    public static class SingleAxleSmallBogie
    extends SingleAxleBogieVisual {
        public final TransformedInstance frame;
        public final TransformedInstance shaft1;
        public final TransformedInstance shaft2;
        public final TransformedInstance wheel;

        public SingleAxleSmallBogie(VisualizationContext ctx, float partialTick, boolean inContraption) {
            super(ctx, partialTick, inContraption);
            this.frame = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.smoothLit((PartialModel)BogiePartials.SMALL_BOGIE_2_FRAME)).createInstance();
            this.shaft1 = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.smoothLit((PartialModel)AllPartialModels.SHAFT)).createInstance();
            this.shaft2 = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.smoothLit((PartialModel)AllPartialModels.SHAFT)).createInstance();
            this.wheel = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.smoothLit((PartialModel)AllPartialModels.SMALL_BOGEY_WHEELS)).createInstance();
        }

        @Override
        public void update(boolean forwards, float wheelAngle, PoseStack poseStack) {
            super.update(forwards, wheelAngle, poseStack);
            ((TransformedInstance)this.frame.setTransform(poseStack).scale(0.9980469f)).setChanged();
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.shaft1.setTransform(poseStack).translate(-0.5f, 0.25f, 0.0f).center()).rotateTo(Direction.UP, Direction.SOUTH)).rotateYDegrees(wheelAngle)).uncenter()).setChanged();
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.shaft2.setTransform(poseStack).translate(-0.5f, 0.25f, -1.0f).center()).rotateTo(Direction.UP, Direction.SOUTH)).rotateYDegrees(wheelAngle)).uncenter()).setChanged();
            ((TransformedInstance)this.wheel.setTransform(poseStack).translate(0.0f, 0.75f, 0.0f).rotateXDegrees(wheelAngle)).setChanged();
        }

        @Override
        public void hide() {
            super.hide();
            this.frame.setZeroTransform().setChanged();
            this.shaft1.setZeroTransform().setChanged();
            this.shaft2.setZeroTransform().setChanged();
            this.wheel.setZeroTransform().setChanged();
        }

        @Override
        public void updateLight(int packedLight) {
            this.frame.light(packedLight).setChanged();
            this.shaft1.light(packedLight).setChanged();
            this.shaft2.light(packedLight).setChanged();
            this.wheel.light(packedLight).setChanged();
        }

        @Override
        public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
            super.collectCrumblingInstances(consumer);
            consumer.accept((Instance)this.frame);
            consumer.accept((Instance)this.shaft1);
            consumer.accept((Instance)this.shaft2);
            consumer.accept((Instance)this.wheel);
        }

        @Override
        public void delete() {
            super.delete();
            this.frame.delete();
            this.shaft1.delete();
            this.shaft2.delete();
            this.wheel.delete();
        }
    }

    public static class SingleAxleSmallOffset
    extends SingleAxleBogieVisual {
        public final TransformedInstance frame;
        public final TransformedInstance shaft;
        public final TransformedInstance wheel;

        public SingleAxleSmallOffset(VisualizationContext ctx, float partialTick, boolean inContraption) {
            super(ctx, partialTick, inContraption);
            this.frame = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.smoothLit((PartialModel)BogiePartials.SMALL_OFFSET_2_FRAME)).createInstance();
            this.shaft = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.smoothLit((PartialModel)AllPartialModels.SHAFT)).createInstance();
            this.wheel = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.smoothLit((PartialModel)AllPartialModels.SMALL_BOGEY_WHEELS)).createInstance();
        }

        @Override
        public void update(boolean forwards, float wheelAngle, PoseStack poseStack) {
            super.update(forwards, wheelAngle, poseStack);
            ((TransformedInstance)((TransformedInstance)this.frame.setTransform(poseStack).scale(0.9980469f)).rotateYDegrees(forwards ? 0.0f : 180.0f)).setChanged();
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.shaft.setTransform(poseStack).translate(-0.5f, 0.25f, forwards ? -1.0f : 0.0f).center()).rotateTo(Direction.UP, Direction.SOUTH)).rotateYDegrees(wheelAngle)).uncenter()).setChanged();
            ((TransformedInstance)this.wheel.setTransform(poseStack).translate(0.0f, 0.75f, forwards ? -1.0f : 1.0f).rotateXDegrees(wheelAngle)).setChanged();
        }

        @Override
        public void hide() {
            super.hide();
            this.frame.setZeroTransform().setChanged();
            this.shaft.setZeroTransform().setChanged();
            this.wheel.setZeroTransform().setChanged();
        }

        @Override
        public void updateLight(int packedLight) {
            this.frame.light(packedLight).setChanged();
            this.shaft.light(packedLight).setChanged();
            this.wheel.light(packedLight).setChanged();
        }

        @Override
        public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
            super.collectCrumblingInstances(consumer);
            consumer.accept((Instance)this.frame);
            consumer.accept((Instance)this.shaft);
            consumer.accept((Instance)this.wheel);
        }

        @Override
        public void delete() {
            super.delete();
            this.frame.delete();
            this.shaft.delete();
            this.wheel.delete();
        }
    }
}

